package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.BusinessProductMapping;
import com.xforceplus.ultraman.app.casservice.service.IBusinessProductMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-07
 */
@RestController
public class BusinessProductMappingController {

  @Autowired
  private IBusinessProductMappingService businessProductMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessProductMapping ${table.comment}
   * @return
   */
  @GetMapping("/businessproductmappings" )
  public XfR getBusinessProductMappings(XfPage page, BusinessProductMapping businessProductMapping) {
    return XfR.ok(businessProductMappingServiceImpl.page(page, Wrappers.query(businessProductMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessproductmappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessProductMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param businessProductMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/businessproductmappings")
  public XfR save(@RequestBody BusinessProductMapping businessProductMapping) {
     return XfR.ok(businessProductMappingServiceImpl.save(businessProductMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param businessProductMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/businessproductmappings/{id}")
  public XfR putUpdate(@RequestBody BusinessProductMapping businessProductMapping,@PathVariable Long id) {
      businessProductMapping.setId(id);
      return XfR.ok(businessProductMappingServiceImpl.updateById(businessProductMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param businessProductMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/businessproductmappings/{id}")
  public XfR patchUpdate(@RequestBody BusinessProductMapping businessProductMapping,@PathVariable Long id) {
      BusinessProductMapping upbusinessProductMapping = businessProductMappingServiceImpl.getById(id);
      if(upbusinessProductMapping != null){
        upbusinessProductMapping = ObjectCopyUtils.copyProperties(businessProductMapping,upbusinessProductMapping,true);
      }
      return XfR.ok(businessProductMappingServiceImpl.updateById(upbusinessProductMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessproductmappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessProductMappingServiceImpl.removeById(id));
  }

  @PostMapping("/businessproductmappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_product_mapping");
     params.put("request", condition);

     return XfR.ok(businessProductMappingServiceImpl.querys(params));
  }

}
