package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.CustomerProductGroupRelation;
import com.xforceplus.ultraman.app.casservice.service.ICustomerProductGroupRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-07
 */
@RestController
public class CustomerProductGroupRelationController {

  @Autowired
  private ICustomerProductGroupRelationService customerProductGroupRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customerProductGroupRelation ${table.comment}
   * @return
   */
  @GetMapping("/customerproductgrouprelations" )
  public XfR getCustomerProductGroupRelations(XfPage page, CustomerProductGroupRelation customerProductGroupRelation) {
    return XfR.ok(customerProductGroupRelationServiceImpl.page(page, Wrappers.query(customerProductGroupRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customerproductgrouprelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customerProductGroupRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customerProductGroupRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/customerproductgrouprelations")
  public XfR save(@RequestBody CustomerProductGroupRelation customerProductGroupRelation) {
     return XfR.ok(customerProductGroupRelationServiceImpl.save(customerProductGroupRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customerProductGroupRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/customerproductgrouprelations/{id}")
  public XfR putUpdate(@RequestBody CustomerProductGroupRelation customerProductGroupRelation,@PathVariable Long id) {
      customerProductGroupRelation.setId(id);
      return XfR.ok(customerProductGroupRelationServiceImpl.updateById(customerProductGroupRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customerProductGroupRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customerproductgrouprelations/{id}")
  public XfR patchUpdate(@RequestBody CustomerProductGroupRelation customerProductGroupRelation,@PathVariable Long id) {
      CustomerProductGroupRelation upcustomerProductGroupRelation = customerProductGroupRelationServiceImpl.getById(id);
      if(upcustomerProductGroupRelation != null){
        upcustomerProductGroupRelation = ObjectCopyUtils.copyProperties(customerProductGroupRelation,upcustomerProductGroupRelation,true);
      }
      return XfR.ok(customerProductGroupRelationServiceImpl.updateById(upcustomerProductGroupRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customerproductgrouprelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customerProductGroupRelationServiceImpl.removeById(id));
  }

  @PostMapping("/customerproductgrouprelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customer_product_group_relation");
     params.put("request", condition);

     return XfR.ok(customerProductGroupRelationServiceImpl.querys(params));
  }

}
