package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.OrgSoldToParty;
import com.xforceplus.ultraman.app.casservice.service.IOrgSoldToPartyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-07
 */
@RestController
public class OrgSoldToPartyController {

  @Autowired
  private IOrgSoldToPartyService orgSoldToPartyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orgSoldToParty ${table.comment}
   * @return
   */
  @GetMapping("/orgsoldtopartys" )
  public XfR getOrgSoldToPartys(XfPage page, OrgSoldToParty orgSoldToParty) {
    return XfR.ok(orgSoldToPartyServiceImpl.page(page, Wrappers.query(orgSoldToParty)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orgsoldtopartys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orgSoldToPartyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orgSoldToParty ${table.comment}
   * @return XfR
   */
  @PostMapping("/orgsoldtopartys")
  public XfR save(@RequestBody OrgSoldToParty orgSoldToParty) {
     return XfR.ok(orgSoldToPartyServiceImpl.save(orgSoldToParty));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orgSoldToParty ${table.comment}
   * @return XfR
   */
  @PutMapping("/orgsoldtopartys/{id}")
  public XfR putUpdate(@RequestBody OrgSoldToParty orgSoldToParty,@PathVariable Long id) {
      orgSoldToParty.setId(id);
      return XfR.ok(orgSoldToPartyServiceImpl.updateById(orgSoldToParty));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orgSoldToParty ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orgsoldtopartys/{id}")
  public XfR patchUpdate(@RequestBody OrgSoldToParty orgSoldToParty,@PathVariable Long id) {
      OrgSoldToParty uporgSoldToParty = orgSoldToPartyServiceImpl.getById(id);
      if(uporgSoldToParty != null){
        uporgSoldToParty = ObjectCopyUtils.copyProperties(orgSoldToParty,uporgSoldToParty,true);
      }
      return XfR.ok(orgSoldToPartyServiceImpl.updateById(uporgSoldToParty));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orgsoldtopartys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orgSoldToPartyServiceImpl.removeById(id));
  }

  @PostMapping("/orgsoldtopartys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "org_sold_to_party");
     params.put("request", condition);

     return XfR.ok(orgSoldToPartyServiceImpl.querys(params));
  }

}
