package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.ConfigRule;
import com.xforceplus.ultraman.app.casservice.service.IConfigRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-07
 */
@RestController
public class ConfigRuleController {

  @Autowired
  private IConfigRuleService configRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configRule ${table.comment}
   * @return
   */
  @GetMapping("/configrules" )
  public XfR getConfigRules(XfPage page, ConfigRule configRule) {
    return XfR.ok(configRuleServiceImpl.page(page, Wrappers.query(configRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/configrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param configRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/configrules")
  public XfR save(@RequestBody ConfigRule configRule) {
     return XfR.ok(configRuleServiceImpl.save(configRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param configRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/configrules/{id}")
  public XfR putUpdate(@RequestBody ConfigRule configRule,@PathVariable Long id) {
      configRule.setId(id);
      return XfR.ok(configRuleServiceImpl.updateById(configRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param configRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/configrules/{id}")
  public XfR patchUpdate(@RequestBody ConfigRule configRule,@PathVariable Long id) {
      ConfigRule upconfigRule = configRuleServiceImpl.getById(id);
      if(upconfigRule != null){
        upconfigRule = ObjectCopyUtils.copyProperties(configRule,upconfigRule,true);
      }
      return XfR.ok(configRuleServiceImpl.updateById(upconfigRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configRuleServiceImpl.removeById(id));
  }

  @PostMapping("/configrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_rule");
     params.put("request", condition);

     return XfR.ok(configRuleServiceImpl.querys(params));
  }

}
