package com.xforceplus.ultraman.app.compass.controller;


/**
 * 与索迪斯重新对接SAP的业务单feign客户端
 *
 * @author ultraman
 * @date 2025-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.BizOrder;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "compass")
public interface BizOrderFeignApi {

  /**
   * 通过id查询与索迪斯重新对接SAP的业务单
   * @param  id
   * @return R
   */
  @GetMapping("/bizOrder/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增与索迪斯重新对接SAP的业务单
   * @param bizOrder 与索迪斯重新对接SAP的业务单
   * @return R
   */
  @PostMapping("/bizOrder/add")
  public R save(@RequestBody BizOrder bizOrder);

  /**
   * 修改与索迪斯重新对接SAP的业务单
   * @param bizOrder 与索迪斯重新对接SAP的业务单
   * @return R
   */
  @PostMapping("/bizOrder/update")
  public R updateById(@RequestBody BizOrder bizOrder);

  /**
   * 通过id删除与索迪斯重新对接SAP的业务单
   * @param  id
   * @return R
   */
  @DeleteMapping("/bizOrder/del/{id}" )
  public R removeById(@PathVariable Long id);

}