package com.xforceplus.ultraman.app.compass.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 账单表
 * </p>
 *
 * @author ultraman
 * @since 2022-02-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Bill implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 账单编号
   */
  private String billNo;

  /**
   * 账单年
   */
  private String billYy;

  /**
   * 账单年月(yyyyMM)
   */
  private String billYm;

  /**
   * 账单状态
   */
  private String status;

  /**
   * 销方公司名称
   */
  private String sellerName;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 购方公司名称
   */
  private String purchaseName;

  /**
   * 购方税号
   */
  private String purchaseTaxNo;

  /**
   * 含税总额
   */
  private BigDecimal amountWithTax;

  /**
   * 不含税总额
   */
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 价格方式
   */
  private String priceMethod;

  /**
   * 返利金额汇总(不含税)
   */
  private BigDecimal rebateWithoutTax;

  /**
   * 返利金额汇总(含税)
   */
  private BigDecimal rebateWithTax;

  /**
   * 返利税额汇总
   */
  private BigDecimal rebateAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 备注
   */
  private String remark;

  /**
   * 购方租户ID
   */
  private String purchaserTenantId;

  /**
   * 结算模式
   */
  private String settlementMode;

  /**
   * 结算单生成状态
   */
  private String settlementStatus;

  /**
   * 销方租户ID
   */
  private String sellerTenantId;

  /**
   * 结算期间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementCycle;

  /**
   * 销方账单状态
   */
  private String sellerStatus;

  /**
   * 异常原因
   */
  private String errorRemark;

  /**
   * 普票返利金额(含税)
   */
  private BigDecimal generalWithTaxRebate;

  /**
   * 专票返利金额(不含税)
   */
  private BigDecimal specialWithoutTaxRebate;

  /**
   * 合计返利金额
   */
  private BigDecimal totalRebate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bill_no", billNo);
      map.put("bill_yy", billYy);
      map.put("bill_ym", billYm);
      map.put("status", status);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("purchase_name", purchaseName);
      map.put("purchase_tax_no", purchaseTaxNo);
      map.put("amount_with_tax", amountWithTax);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("price_method", priceMethod);
      map.put("rebate_without_tax", rebateWithoutTax);
      map.put("rebate_with_tax", rebateWithTax);
      map.put("rebate_amount", rebateAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("remark", remark);
      map.put("purchaser_tenant_id", purchaserTenantId);
      map.put("settlement_mode", settlementMode);
      map.put("settlement_status", settlementStatus);
      map.put("seller_tenant_id", sellerTenantId);
      map.put("settlement_cycle", BocpGenUtils.toTimestamp(settlementCycle));
      map.put("seller_status", sellerStatus);
      map.put("error_remark", errorRemark);
      map.put("general_with_tax_rebate", generalWithTaxRebate);
      map.put("special_without_tax_rebate", specialWithoutTaxRebate);
      map.put("total_rebate", totalRebate);
      return map;
  }

  public static Bill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Bill entity = new Bill();
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_yy")) {
      Object obj = map.get("bill_yy");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillYy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_ym")) {
      Object obj = map.get("bill_ym");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillYm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_name")) {
      Object obj = map.get("purchase_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_tax_no")) {
      Object obj = map.get("purchase_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("price_method")) {
      Object obj = map.get("price_method");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebate_without_tax")) {
      Object obj = map.get("rebate_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_with_tax")) {
      Object obj = map.get("rebate_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_amount")) {
      Object obj = map.get("rebate_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tenant_id")) {
      Object obj = map.get("purchaser_tenant_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_mode")) {
      Object obj = map.get("settlement_mode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_status")) {
      Object obj = map.get("settlement_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_cycle")) {
      Object obj = map.get("settlement_cycle");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementCycle(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSettlementCycle((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementCycle(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementCycle(null);
      }
    }
    if(map.containsKey("seller_status")) {
      Object obj = map.get("seller_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_remark")) {
      Object obj = map.get("error_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setErrorRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("general_with_tax_rebate")) {
      Object obj = map.get("general_with_tax_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGeneralWithTaxRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGeneralWithTaxRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGeneralWithTaxRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setGeneralWithTaxRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGeneralWithTaxRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("special_without_tax_rebate")) {
      Object obj = map.get("special_without_tax_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSpecialWithoutTaxRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSpecialWithoutTaxRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSpecialWithoutTaxRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSpecialWithoutTaxRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSpecialWithoutTaxRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_rebate")) {
      Object obj = map.get("total_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_yy")) {
      Object obj = map.get("bill_yy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillYy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_ym")) {
      Object obj = map.get("bill_ym");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillYm((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_name")) {
      Object obj = map.get("purchase_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_tax_no")) {
      Object obj = map.get("purchase_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("price_method")) {
      Object obj = map.get("price_method");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPriceMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rebate_without_tax")) {
      Object obj = map.get("rebate_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebateWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebateWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebateWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setRebateWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebateWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebate_with_tax")) {
      Object obj = map.get("rebate_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebateWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebateWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebateWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setRebateWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebateWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebate_amount")) {
      Object obj = map.get("rebate_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setRebateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tenant_id")) {
      Object obj = map.get("purchaser_tenant_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTenantId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_mode")) {
      Object obj = map.get("settlement_mode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_status")) {
      Object obj = map.get("settlement_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTenantId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_cycle")) {
      Object obj = map.get("settlement_cycle");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSettlementCycle(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSettlementCycle((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setSettlementCycle(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSettlementCycle(null);
      }
    }
    if(map.containsKey("seller_status")) {
      Object obj = map.get("seller_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_remark")) {
      Object obj = map.get("error_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("general_with_tax_rebate")) {
      Object obj = map.get("general_with_tax_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGeneralWithTaxRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGeneralWithTaxRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGeneralWithTaxRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setGeneralWithTaxRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGeneralWithTaxRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("special_without_tax_rebate")) {
      Object obj = map.get("special_without_tax_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSpecialWithoutTaxRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSpecialWithoutTaxRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSpecialWithoutTaxRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setSpecialWithoutTaxRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSpecialWithoutTaxRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("total_rebate")) {
      Object obj = map.get("total_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTotalRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
  }
}
