package com.xforceplus.ultraman.app.compass.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MiroNoCoopSettlement implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 销方编号
   */
  private String sellerNo;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 购方编号
   */
  private String purchaserNo;

  /**
   * 购方名称
   */
  private String purchaserName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 邮件发送记录
   */
  private String emailRecord;

  /**
   * 短信发送记录
   */
  private String messageRecord;

  /**
   * 结算单号
   */
  private String settlementNo;

  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 联合订单号
   */
  private String relateOrderNo;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 购方地址
   */
  private String purchaserAddress;

  /**
   * 购方手机
   */
  private String purchaserPhone;

  /**
   * 购方邮箱
   */
  private String purchaserEmail;

  /**
   * 购方开户行
   */
  private String purchaserBank;

  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 销方地址
   */
  private String sellerAddress;

  /**
   * 销方手机
   */
  private String sellerPhone;

  /**
   * 销方邮箱
   */
  private String sellerEmail;

  /**
   * 销方开户行
   */
  private String sellerBank;

  /**
   * 销方银行账号
   */
  private String sellerBankAccount;

  /**
   * 上传状态
   */
  private String uploadStatus;

  /**
   * 批次号
   */
  private String batchNo;

  /**
   * 非协同结算单状态
   */
  private String noCoopSettlementStatus;

  /**
   * 结算单封面
   */
  private String settlementFront;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 短信发送次数
   */
  private Long smsSendCount;

  /**
   * 结算期间
   */
  private String ext12;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("amount_with_tax", amountWithTax);
      map.put("seller_no", sellerNo);
      map.put("seller_name", sellerName);
      map.put("purchaser_no", purchaserNo);
      map.put("purchaser_name", purchaserName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("email_record", emailRecord);
      map.put("message_record", messageRecord);
      map.put("settlement_no", settlementNo);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("relate_order_no", relateOrderNo);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_phone", purchaserPhone);
      map.put("purchaser_email", purchaserEmail);
      map.put("purchaser_bank", purchaserBank);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("seller_address", sellerAddress);
      map.put("seller_phone", sellerPhone);
      map.put("seller_email", sellerEmail);
      map.put("seller_bank", sellerBank);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("upload_status", uploadStatus);
      map.put("batch_no", batchNo);
      map.put("no_coop_settlement_status", noCoopSettlementStatus);
      map.put("settlement_front", settlementFront);
      map.put("invoice_type", invoiceType);
      map.put("sms_send_count", smsSendCount);
      map.put("ext12", ext12);
      return map;
  }

  public static MiroNoCoopSettlement fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MiroNoCoopSettlement entity = new MiroNoCoopSettlement();
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("email_record")) {
      Object obj = map.get("email_record");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEmailRecord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("message_record")) {
      Object obj = map.get("message_record");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMessageRecord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("relate_order_no")) {
      Object obj = map.get("relate_order_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelateOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_phone")) {
      Object obj = map.get("purchaser_phone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_email")) {
      Object obj = map.get("purchaser_email");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank")) {
      Object obj = map.get("purchaser_bank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_phone")) {
      Object obj = map.get("seller_phone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_email")) {
      Object obj = map.get("seller_email");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank")) {
      Object obj = map.get("seller_bank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upload_status")) {
      Object obj = map.get("upload_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUploadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("no_coop_settlement_status")) {
      Object obj = map.get("no_coop_settlement_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNoCoopSettlementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_front")) {
      Object obj = map.get("settlement_front");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementFront((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sms_send_count")) {
      Object obj = map.get("sms_send_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSmsSendCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setSmsSendCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSmsSendCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
