package com.xforceplus.ultraman.app.compass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * no_coop_settle_period
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum NoCoopSettlePeriod {

    _0("0", "月"),
    _1("1", "季"),
    _2("2", "半年"),
    _3("3", "年"),
    _4("4", "日");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NoCoopSettlePeriod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoCoopSettlePeriod fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
