package com.xforceplus.ultraman.app.compass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * seller_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum SellerStatus {

    _2("2", "待确认"),
    _6("6", "已确认"),
    _7("7", "异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SellerStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerStatus fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
