package com.xforceplus.ultraman.app.compass.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MiroBillDetails implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 结算单号
   */
  private String settlementNo;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 是否有影像
   */
  private String isImage;

  /**
   * 子结算单号
   */
  private String settlementSeq;

  /**
   * 开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceTime;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 发票扫描时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceScanTime;

  /**
   * 发票查验状态
   */
  private String invoiceVerify;

  /**
   * 发票含税金额
   */
  private BigDecimal invoiceAmountWithTax;

  /**
   * 发票状态
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * 返利利率
   */
  private BigDecimal rebateRate;

  /**
   * 查询开始时间
   */
  private String startTime;

  /**
   * 查询结束时间
   */
  private String endTime;

  /**
   * GL账户
   */
  private String glAccount;

  /**
   * 发票不含税金额
   */
  private BigDecimal invoiceAmountWithoutTax;

  /**
   * 发票税额
   */
  private BigDecimal invoiceTax;

  /**
   * 订单号
   */
  private String orderNo;

  /**
   * 拓展字段汇总
   */
  private String exts;

  /**
   * pdf地址
   */
  @TableField("pdfUrl")
  private String pdfUrl;

  /**
   * 图片地址
   */
  @TableField("imgUrl")
  private String imgUrl;

  /**
   * 发票来源
   */
  @TableField("invoiceOrig")
  private String invoiceOrig;

  /**
   * 销方地址
   */
  private String sellerAddress;

  /**
   * 销方电话
   */
  private String sellerPhone;

  /**
   * 原蓝字发票号码
   */
  private String originInvoiceNo;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 miroResult
   */
    private Long miroResultOtmDetailsId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("settlement_no", settlementNo);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("is_image", isImage);
      map.put("settlement_seq", settlementSeq);
      map.put("invoice_time", BocpGenUtils.toTimestamp(invoiceTime));
      map.put("invoice_type", invoiceType);
      map.put("invoice_scan_time", BocpGenUtils.toTimestamp(invoiceScanTime));
      map.put("invoice_verify", invoiceVerify);
      map.put("invoice_amount_with_tax", invoiceAmountWithTax);
      map.put("invoiceStatus", invoiceStatus);
      map.put("rebate_rate", rebateRate);
      map.put("start_time", startTime);
      map.put("end_time", endTime);
      map.put("gl_account", glAccount);
      map.put("invoice_amount_without_tax", invoiceAmountWithoutTax);
      map.put("invoice_tax", invoiceTax);
      map.put("order_no", orderNo);
      map.put("exts", exts);
      map.put("pdfUrl", pdfUrl);
      map.put("imgUrl", imgUrl);
      map.put("invoiceOrig", invoiceOrig);
      map.put("seller_address", sellerAddress);
      map.put("seller_phone", sellerPhone);
      map.put("origin_invoice_no", originInvoiceNo);
      map.put("org_tree", orgTree);

       map.put("miroResultOtmDetails.id", miroResultOtmDetailsId);
      return map;
  }

  public static MiroBillDetails fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MiroBillDetails entity = new MiroBillDetails();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_image")) {
      Object obj = map.get("is_image");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_seq")) {
      Object obj = map.get("settlement_seq");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementSeq((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_time")) {
      Object obj = map.get("invoice_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceTime(null);
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_scan_time")) {
      Object obj = map.get("invoice_scan_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceScanTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceScanTime(null);
      }
    }
    if(map.containsKey("invoice_verify")) {
      Object obj = map.get("invoice_verify");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceVerify((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_amount_with_tax")) {
      Object obj = map.get("invoice_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebate_rate")) {
      Object obj = map.get("rebate_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebateRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("start_time")) {
      Object obj = map.get("start_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("end_time")) {
      Object obj = map.get("end_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEndTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gl_account")) {
      Object obj = map.get("gl_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGlAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_amount_without_tax")) {
      Object obj = map.get("invoice_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_tax")) {
      Object obj = map.get("invoice_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exts")) {
      Object obj = map.get("exts");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExts((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imgUrl")) {
      Object obj = map.get("imgUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_phone")) {
      Object obj = map.get("seller_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("miroResultOtmDetails.id")) {
        Object obj = map.get("miroResultOtmDetails.id");
      if(obj instanceof Long) {
        entity.setMiroResultOtmDetailsId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setMiroResultOtmDetailsId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_image")) {
      Object obj = map.get("is_image");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsImage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_seq")) {
      Object obj = map.get("settlement_seq");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementSeq((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_time")) {
      Object obj = map.get("invoice_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceTime(null);
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_scan_time")) {
      Object obj = map.get("invoice_scan_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceScanTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceScanTime(null);
      }
    }
    if(map.containsKey("invoice_verify")) {
      Object obj = map.get("invoice_verify");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceVerify((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_amount_with_tax")) {
      Object obj = map.get("invoice_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rebate_rate")) {
      Object obj = map.get("rebate_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebateRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebateRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebateRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebateRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebateRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("start_time")) {
      Object obj = map.get("start_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStartTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("end_time")) {
      Object obj = map.get("end_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEndTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gl_account")) {
      Object obj = map.get("gl_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGlAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_amount_without_tax")) {
      Object obj = map.get("invoice_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_tax")) {
      Object obj = map.get("invoice_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exts")) {
      Object obj = map.get("exts");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExts((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPdfUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imgUrl")) {
      Object obj = map.get("imgUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImgUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_phone")) {
      Object obj = map.get("seller_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("miroResultOtmDetails.id")) {
        Object obj = map.get("miroResultOtmDetails.id");
        if(obj instanceof Long) {
          this.setMiroResultOtmDetailsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMiroResultOtmDetailsId(Long.parseLong((String)obj));
        }
      }
  }
}
