package com.xforceplus.ultraman.app.compass.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2022-08-08
 */
public enum InvoiceType {

    C("c", "增值税普通发票"),
    S("s", "增值税专用发票"),
    CE("ce", "增值税电子普通发票"),
    SE("se", "增值税电子专用发票"),
    V("v", "机动车销售发票"),
    T("t", "通用机打发票"),
    Y("y", "运输业增值税专用发票"),
    JU("ju", "增值税普通发票（卷票）"),
    VS("vs", "二手车发票"),
    CP("cp", "进口增值税缴款书发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "c":
                return C;
            case "s":
                return S;
            case "ce":
                return CE;
            case "se":
                return SE;
            case "v":
                return V;
            case "t":
                return T;
            case "y":
                return Y;
            case "ju":
                return JU;
            case "vs":
                return VS;
            case "cp":
                return CP;
            default:
                return null;
        }
    }
}
