package com.xforceplus.ultraman.app.compass.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 非协同结算单状态
 * </p>
 *
 * @author ultraman
 * @since 2022-08-17
 */
public enum NoCoopSettlementStatus {

    _0("0", "未记账"),
    _1("1", "已记账"),
    _2("2", "作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoCoopSettlementStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoCoopSettlementStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
