package com.xforceplus.ultraman.app.compass.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 销方账单状态
 * </p>
 *
 * @author ultraman
 * @since 2022-08-17
 */
public enum SellerStatus {

    _2("2", "待确认"),
    _6("6", "已确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SellerStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerStatus fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
