package com.xforceplus.ultraman.app.compass.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2022-08-17
*/
public class EntityMeta {
    public interface Bill {
        static Long id() {
            return 1423582025706938370L;
        }
        static String code() {
            return "bill";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<String> BILL_YY = new TypedField<>(String.class, "bill_yy");
        TypedField<String> BILL_YM = new TypedField<>(String.class, "bill_ym");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> PURCHASE_NAME = new TypedField<>(String.class, "purchase_name");
        TypedField<String> PURCHASE_TAX_NO = new TypedField<>(String.class, "purchase_tax_no");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<BigDecimal> REBATE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "rebate_without_tax");
        TypedField<BigDecimal> REBATE_WITH_TAX = new TypedField<>(BigDecimal.class, "rebate_with_tax");
        TypedField<BigDecimal> REBATE_AMOUNT = new TypedField<>(BigDecimal.class, "rebate_amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> PURCHASER_TENANT_ID = new TypedField<>(String.class, "purchaser_tenant_id");
        TypedField<String> SETTLEMENT_MODE = new TypedField<>(String.class, "settlement_mode");
        TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "settlement_status");
        TypedField<String> SELLER_TENANT_ID = new TypedField<>(String.class, "seller_tenant_id");
        TypedField<LocalDateTime> SETTLEMENT_CYCLE = new TypedField<>(LocalDateTime.class, "settlement_cycle");
        TypedField<String> SELLER_STATUS = new TypedField<>(String.class, "seller_status");
        TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "error_remark");
        TypedField<BigDecimal> GENERAL_WITH_TAX_REBATE = new TypedField<>(BigDecimal.class, "general_with_tax_rebate");
        TypedField<BigDecimal> SPECIAL_WITHOUT_TAX_REBATE = new TypedField<>(BigDecimal.class, "special_without_tax_rebate");
        TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "total_rebate");
    }
    public interface BillInvoice {
        static Long id() {
            return 1423584766047068162L;
        }
        static String code() {
            return "billInvoice";
        }
        TypedField<Long> BILL_ID = new TypedField<>(Long.class, "bill_id");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paper_drew_date");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> RED_FLAG = new TypedField<>(String.class, "red_flag");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> TOTAL_AMOUNT_TAX_NUM = new TypedField<>(BigDecimal.class, "total_amount_tax_num");
        TypedField<String> SETTLEMENT_MODE = new TypedField<>(String.class, "settlement_mode");
        TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "scan_status");
        TypedField<String> SCAN_TIME = new TypedField<>(String.class, "scan_time");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "auth_status");
        TypedField<String> AUTH_TIME = new TypedField<>(String.class, "auth_time");
        TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoice_color");
        TypedField<BigDecimal> REBATE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "rebate_without_tax");
        TypedField<BigDecimal> REBATE_WITH_TAX = new TypedField<>(BigDecimal.class, "rebate_with_tax");
        TypedField<BigDecimal> REBATE_AMOUNT = new TypedField<>(BigDecimal.class, "rebate_amount");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlement_cycle");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "red_notification_no");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<String> PROJECT_ADDR = new TypedField<>(String.class, "project_addr");
        TypedField<String> RED_TIME = new TypedField<>(String.class, "red_time");
        TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "total_rebate");
        TypedField<String> INVOICE = new TypedField<>(String.class, "invoice");
    }
    public interface BillDetails {
        static Long id() {
            return 1423587553002692609L;
        }
        static String code() {
            return "billDetails";
        }
        TypedField<Long> BILL_INVOICE_ID = new TypedField<>(Long.class, "bill_invoice_id");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "already_make_amount_without_tax");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "already_make_amount_with_tax");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT = new TypedField<>(BigDecimal.class, "already_make_amount");
        TypedField<BigDecimal> RATE = new TypedField<>(BigDecimal.class, "rate");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "sales_bill_no");
        TypedField<String> SALES_BILL_ITEM_NO = new TypedField<>(String.class, "sales_bill_item_no");
        TypedField<BigDecimal> REBATE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "rebate_without_tax");
        TypedField<BigDecimal> REBATE_WITH_TAX = new TypedField<>(BigDecimal.class, "rebate_with_tax");
        TypedField<BigDecimal> REBATE_AMOUNT = new TypedField<>(BigDecimal.class, "rebate_amount");
        TypedField<Long> REBATE_RATE = new TypedField<>(Long.class, "rebate_rate");
        TypedField<String> PROJECT_ADDR = new TypedField<>(String.class, "project_addr");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlement_cycle");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> ITEM_ID = new TypedField<>(Long.class, "item_id");
        TypedField<BigDecimal> REBATE_MONEY = new TypedField<>(BigDecimal.class, "rebate_money");
    }
    public interface YearBill {
        static Long id() {
            return 1499221813372588033L;
        }
        static String code() {
            return "yearBill";
        }
        TypedField<String> YEAR = new TypedField<>(String.class, "year");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_TENANT_ID = new TypedField<>(String.class, "seller_tenant_id");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_TENANT_ID = new TypedField<>(String.class, "purchaser_tenant_id");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "error_remark");
        TypedField<BigDecimal> GENERAL_WITH_TAX_REBATE = new TypedField<>(BigDecimal.class, "general_with_tax_rebate");
        TypedField<BigDecimal> SPECIAL_WITHOUT_TAX_REBATE = new TypedField<>(BigDecimal.class, "special_without_tax_rebate");
        TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "total_rebate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "year_bill_no");
        TypedField<String> CANCEL_REMARK = new TypedField<>(String.class, "cancel_remark");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface YearBillMain {
        static Long id() {
            return 1499244937229045761L;
        }
        static String code() {
            return "yearBillMain";
        }
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbill_no");
        TypedField<String> SALESBILL_TYPE = new TypedField<>(String.class, "salesbill_type");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> UPLOAD_MSG_ID = new TypedField<>(String.class, "upload_msg_id");
        TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "error_remark");
        TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "year_bill_no");
        /**
         * 对一关联关系 关联对象 yearBill
         */
        TypedField<Long> YEAR_BILL_ID = new TypedField<>(Long.class, "yearBill.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface YEAR_BILL {
                static String code () {
                    return "yearBill" ;
                }
                TypedField<String> YEAR = new TypedField<>(String.class, "yearBill.year");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "yearBill.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "yearBill.seller_tax_no");
                TypedField<String> SELLER_TENANT_ID = new TypedField<>(String.class, "yearBill.seller_tenant_id");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "yearBill.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "yearBill.purchaser_tax_no");
                TypedField<String> PURCHASER_TENANT_ID = new TypedField<>(String.class, "yearBill.purchaser_tenant_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "yearBill.status");
                TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "yearBill.error_remark");
                TypedField<BigDecimal> GENERAL_WITH_TAX_REBATE = new TypedField<>(BigDecimal.class, "yearBill.general_with_tax_rebate");
                TypedField<BigDecimal> SPECIAL_WITHOUT_TAX_REBATE = new TypedField<>(BigDecimal.class, "yearBill.special_without_tax_rebate");
                TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "yearBill.total_rebate");
                TypedField<Long> ID = new TypedField<>(Long.class, "yearBill.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "yearBill.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "yearBill.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "yearBill.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "yearBill.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "yearBill.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "yearBill.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "yearBill.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "yearBill.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "yearBill.delete_flag");
                TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "yearBill.year_bill_no");
                TypedField<String> CANCEL_REMARK = new TypedField<>(String.class, "yearBill.cancel_remark");
            }
        }
    }
    public interface YearBillDetail {
        static Long id() {
            return 1499248408695083010L;
        }
        static String code() {
            return "yearBillDetail";
        }
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbill_no");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> YEAR_BILL_ID = new TypedField<>(Long.class, "year_bill_id");
        TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "year_bill_no");
        /**
         * 对一关联关系 关联对象 yearBillMain
         */
        TypedField<Long> YEAR_BILL_MAIN_ID = new TypedField<>(Long.class, "yearBillMain.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface YEAR_BILL_MAIN {
                static String code () {
                    return "yearBillMain" ;
                }
                TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "yearBillMain.salesbill_no");
                TypedField<String> SALESBILL_TYPE = new TypedField<>(String.class, "yearBillMain.salesbill_type");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "yearBillMain.seller_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "yearBillMain.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "yearBillMain.seller_tax_no");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "yearBillMain.seller_tel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "yearBillMain.seller_address");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "yearBillMain.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "yearBillMain.seller_bank_account");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "yearBillMain.purchaser_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "yearBillMain.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "yearBillMain.purchaser_tax_no");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "yearBillMain.purchaser_tel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "yearBillMain.purchaser_address");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "yearBillMain.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "yearBillMain.purchaser_bank_account");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "yearBillMain.invoice_type");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "yearBillMain.price_method");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "yearBillMain.amount_with_tax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "yearBillMain.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "yearBillMain.tax_amount");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "yearBillMain.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "yearBillMain.origin_invoice_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "yearBillMain.upload_status");
                TypedField<Long> ID = new TypedField<>(Long.class, "yearBillMain.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "yearBillMain.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "yearBillMain.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "yearBillMain.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "yearBillMain.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "yearBillMain.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "yearBillMain.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "yearBillMain.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "yearBillMain.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "yearBillMain.delete_flag");
                TypedField<String> UPLOAD_MSG_ID = new TypedField<>(String.class, "yearBillMain.upload_msg_id");
                TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "yearBillMain.error_remark");
                TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "yearBillMain.year_bill_no");
            }
        }
    }
    public interface InvoiceDetail {
        static Long id() {
            return 1499741904803536898L;
        }
        static String code() {
            return "invoiceDetail";
        }
        TypedField<Long> BILL_ID = new TypedField<>(Long.class, "bill_id");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<Long> BILL_INVOICE_ID = new TypedField<>(Long.class, "bill_invoice_id");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<String> INVOICE_ITEM = new TypedField<>(String.class, "invoice_item");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargo_name");
        TypedField<String> QUANLITY_UNIT = new TypedField<>(String.class, "quanlity_unit");
    }
    public interface SalesbillUpload {
        static Long id() {
            return 1526052519228145666L;
        }
        static String code() {
            return "salesbillUpload";
        }
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "uploadStatus");
        TypedField<String> BILLING_SET_PERIOD = new TypedField<>(String.class, "billingSetPeriod");
        TypedField<LocalDateTime> UPLOAD_DATE = new TypedField<>(LocalDateTime.class, "uploadDate");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> RECEIPT_NO = new TypedField<>(String.class, "receiptNo");
        TypedField<String> PROCESS_REMARK = new TypedField<>(String.class, "processRemark");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");
    }
    public interface MiroBillDetails {
        static Long id() {
            return 1528720721171120130L;
        }
        static String code() {
            return "miroBillDetails";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> IS_IMAGE = new TypedField<>(String.class, "is_image");
        TypedField<String> SETTLEMENT_SEQ = new TypedField<>(String.class, "settlement_seq");
        TypedField<LocalDateTime> INVOICE_TIME = new TypedField<>(LocalDateTime.class, "invoice_time");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<LocalDateTime> INVOICE_SCAN_TIME = new TypedField<>(LocalDateTime.class, "invoice_scan_time");
        TypedField<String> INVOICE_VERIFY = new TypedField<>(String.class, "invoice_verify");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoice_amount_with_tax");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<BigDecimal> REBATE_RATE = new TypedField<>(BigDecimal.class, "rebate_rate");
        TypedField<String> START_TIME = new TypedField<>(String.class, "start_time");
        TypedField<String> END_TIME = new TypedField<>(String.class, "end_time");
        TypedField<String> GL_ACCOUNT = new TypedField<>(String.class, "gl_account");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoice_amount_without_tax");
        TypedField<BigDecimal> INVOICE_TAX = new TypedField<>(BigDecimal.class, "invoice_tax");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        /**
         * 对一关联关系 关联对象 miroResult
         */
        TypedField<Long> MIRO_RESULT_OTM_DETAILS_ID = new TypedField<>(Long.class, "miroResultOtmDetails.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MIRO_RESULT_OTM_DETAILS {
                static String code () {
                    return "miroResultOtmDetails" ;
                }
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "miroResultOtmDetails.settlement_no");
                TypedField<String> SETTLEMENT_SEQ = new TypedField<>(String.class, "miroResultOtmDetails.settlement_seq");
                TypedField<Long> ID = new TypedField<>(Long.class, "miroResultOtmDetails.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "miroResultOtmDetails.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "miroResultOtmDetails.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "miroResultOtmDetails.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "miroResultOtmDetails.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "miroResultOtmDetails.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "miroResultOtmDetails.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "miroResultOtmDetails.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "miroResultOtmDetails.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "miroResultOtmDetails.delete_flag");
                TypedField<LocalDateTime> SETTLEMENT_PERIOD = new TypedField<>(LocalDateTime.class, "miroResultOtmDetails.settlement_period");
                TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "miroResultOtmDetails.settlement_status");
                TypedField<String> ERROR_MSG = new TypedField<>(String.class, "miroResultOtmDetails.error_msg");
                TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "miroResultOtmDetails.send_count");
                TypedField<String> SAP_INVOICE_DOCUMENT = new TypedField<>(String.class, "miroResultOtmDetails.sap_invoice_document");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "miroResultOtmDetails.purchaser_name");
                TypedField<String> PURCHASER_TAX = new TypedField<>(String.class, "miroResultOtmDetails.purchaser_tax");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "miroResultOtmDetails.seller_name");
                TypedField<String> SELLER_TAX = new TypedField<>(String.class, "miroResultOtmDetails.seller_tax");
                TypedField<BigDecimal> SETTLEMENT_AMOUNT = new TypedField<>(BigDecimal.class, "miroResultOtmDetails.settlement_amount");
                TypedField<String> PURCHASER_COMPANY_CODE = new TypedField<>(String.class, "miroResultOtmDetails.purchaser_company_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "miroResultOtmDetails.seller_no");
                TypedField<String> REQUEST_MESSAGE = new TypedField<>(String.class, "miroResultOtmDetails.request_message");
            }
        }
    }
    public interface MiroResult {
        static Long id() {
            return 1528728888462475265L;
        }
        static String code() {
            return "miroResult";
        }
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> SETTLEMENT_SEQ = new TypedField<>(String.class, "settlement_seq");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD = new TypedField<>(LocalDateTime.class, "settlement_period");
        TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "settlement_status");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "error_msg");
        TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "send_count");
        TypedField<String> SAP_INVOICE_DOCUMENT = new TypedField<>(String.class, "sap_invoice_document");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX = new TypedField<>(String.class, "purchaser_tax");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX = new TypedField<>(String.class, "seller_tax");
        TypedField<BigDecimal> SETTLEMENT_AMOUNT = new TypedField<>(BigDecimal.class, "settlement_amount");
        TypedField<String> PURCHASER_COMPANY_CODE = new TypedField<>(String.class, "purchaser_company_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> REQUEST_MESSAGE = new TypedField<>(String.class, "request_message");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface MiroOrderDetail {
        static Long id() {
            return 1531197507019022338L;
        }
        static String code() {
            return "miroOrderDetail";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<String> ORDER_ITEM = new TypedField<>(String.class, "order_item");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> SETTLEMENT_SEQ = new TypedField<>(String.class, "settlement_seq");
        TypedField<String> ORDER_DETAIL_ID = new TypedField<>(String.class, "order_detail_id");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        /**
         * 对一关联关系 关联对象 miroBillDetails
         */
        TypedField<Long> BILL_DEATIL_OTM_ORDER_ID = new TypedField<>(Long.class, "billDeatilOtmOrder.id");
        /**
         * 对一关联关系 关联对象 miroResult
         */
        TypedField<Long> RESULT_OTM_ORDER_ID = new TypedField<>(Long.class, "resultOtmOrder.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DEATIL_OTM_ORDER {
                static String code () {
                    return "billDeatilOtmOrder" ;
                }
                TypedField<Long> ID = new TypedField<>(Long.class, "billDeatilOtmOrder.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDeatilOtmOrder.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDeatilOtmOrder.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDeatilOtmOrder.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDeatilOtmOrder.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDeatilOtmOrder.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDeatilOtmOrder.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDeatilOtmOrder.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDeatilOtmOrder.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDeatilOtmOrder.delete_flag");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billDeatilOtmOrder.settlement_no");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "billDeatilOtmOrder.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "billDeatilOtmOrder.invoice_code");
                TypedField<String> IS_IMAGE = new TypedField<>(String.class, "billDeatilOtmOrder.is_image");
                TypedField<String> SETTLEMENT_SEQ = new TypedField<>(String.class, "billDeatilOtmOrder.settlement_seq");
                TypedField<LocalDateTime> INVOICE_TIME = new TypedField<>(LocalDateTime.class, "billDeatilOtmOrder.invoice_time");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "billDeatilOtmOrder.invoice_type");
                TypedField<LocalDateTime> INVOICE_SCAN_TIME = new TypedField<>(LocalDateTime.class, "billDeatilOtmOrder.invoice_scan_time");
                TypedField<String> INVOICE_VERIFY = new TypedField<>(String.class, "billDeatilOtmOrder.invoice_verify");
                TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billDeatilOtmOrder.invoice_amount_with_tax");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "billDeatilOtmOrder.invoiceStatus");
                TypedField<BigDecimal> REBATE_RATE = new TypedField<>(BigDecimal.class, "billDeatilOtmOrder.rebate_rate");
                TypedField<String> START_TIME = new TypedField<>(String.class, "billDeatilOtmOrder.start_time");
                TypedField<String> END_TIME = new TypedField<>(String.class, "billDeatilOtmOrder.end_time");
                TypedField<String> GL_ACCOUNT = new TypedField<>(String.class, "billDeatilOtmOrder.gl_account");
                TypedField<BigDecimal> INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billDeatilOtmOrder.invoice_amount_without_tax");
                TypedField<BigDecimal> INVOICE_TAX = new TypedField<>(BigDecimal.class, "billDeatilOtmOrder.invoice_tax");
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "billDeatilOtmOrder.order_no");
            }
            interface RESULT_OTM_ORDER {
                static String code () {
                    return "resultOtmOrder" ;
                }
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "resultOtmOrder.settlement_no");
                TypedField<String> SETTLEMENT_SEQ = new TypedField<>(String.class, "resultOtmOrder.settlement_seq");
                TypedField<Long> ID = new TypedField<>(Long.class, "resultOtmOrder.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "resultOtmOrder.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "resultOtmOrder.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "resultOtmOrder.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "resultOtmOrder.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "resultOtmOrder.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "resultOtmOrder.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "resultOtmOrder.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "resultOtmOrder.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "resultOtmOrder.delete_flag");
                TypedField<LocalDateTime> SETTLEMENT_PERIOD = new TypedField<>(LocalDateTime.class, "resultOtmOrder.settlement_period");
                TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "resultOtmOrder.settlement_status");
                TypedField<String> ERROR_MSG = new TypedField<>(String.class, "resultOtmOrder.error_msg");
                TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "resultOtmOrder.send_count");
                TypedField<String> SAP_INVOICE_DOCUMENT = new TypedField<>(String.class, "resultOtmOrder.sap_invoice_document");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "resultOtmOrder.purchaser_name");
                TypedField<String> PURCHASER_TAX = new TypedField<>(String.class, "resultOtmOrder.purchaser_tax");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "resultOtmOrder.seller_name");
                TypedField<String> SELLER_TAX = new TypedField<>(String.class, "resultOtmOrder.seller_tax");
                TypedField<BigDecimal> SETTLEMENT_AMOUNT = new TypedField<>(BigDecimal.class, "resultOtmOrder.settlement_amount");
                TypedField<String> PURCHASER_COMPANY_CODE = new TypedField<>(String.class, "resultOtmOrder.purchaser_company_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "resultOtmOrder.seller_no");
                TypedField<String> REQUEST_MESSAGE = new TypedField<>(String.class, "resultOtmOrder.request_message");
            }
        }
    }
    public interface MiroNoCoopSalesbill {
        static Long id() {
            return 1554356931110375425L;
        }
        static String code() {
            return "miroNoCoopSalesbill";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<String> ORDER_ITEM = new TypedField<>(String.class, "order_item");
        TypedField<String> LARGE_CATEGORY_NAME = new TypedField<>(String.class, "large_category_name");
        TypedField<String> SALESBILL_ITEM_NO = new TypedField<>(String.class, "salesbill_item_no");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_PHONE = new TypedField<>(String.class, "seller_phone");
        TypedField<String> SELLER_BANK = new TypedField<>(String.class, "seller_bank");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_PHONE = new TypedField<>(String.class, "purchaser_phone");
        TypedField<String> PURCHASER_BANK = new TypedField<>(String.class, "purchaser_bank");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbill_no");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT10_DETAIL = new TypedField<>(String.class, "ext10_detail");
        TypedField<String> MEDIAN_CATEGORY_NAME = new TypedField<>(String.class, "median_category_name");
        TypedField<String> SMALL_CATEGORY_NAME = new TypedField<>(String.class, "small_category_name");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT4_DETAIL = new TypedField<>(String.class, "ext4_detail");
        TypedField<String> ITEM_NO = new TypedField<>(String.class, "item_no");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "tax_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> NO_COOP_SALESBILL_STATUS = new TypedField<>(String.class, "no_coop_salesbill_status");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amount_without_tax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "tax_amount");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amount_with_tax");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> UNIT_PRICE = new TypedField<>(String.class, "unit_price");
        TypedField<String> UNIT_PRICE_WITH_TAX = new TypedField<>(String.class, "unit_price_with_tax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> SETTLEMENT_FAIL = new TypedField<>(String.class, "settlement_fail");
        TypedField<String> PURCHASER_EMAIL = new TypedField<>(String.class, "purchaser_email");
        TypedField<String> SELLER_EMAIL = new TypedField<>(String.class, "seller_email");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> NO_COOP_SETTLE_PERIOD = new TypedField<>(String.class, "no_coop_settle_period");
        /**
         * 对一关联关系 关联对象 miroNoCoopSettlement
         */
        TypedField<Long> SETTLEMENT_TO_SALESBILLS_ID = new TypedField<>(Long.class, "settlementToSalesbills.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SETTLEMENT_TO_SALESBILLS {
                static String code () {
                    return "settlementToSalesbills" ;
                }
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementToSalesbills.amount_with_tax");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "settlementToSalesbills.seller_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "settlementToSalesbills.seller_name");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "settlementToSalesbills.purchaser_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "settlementToSalesbills.purchaser_name");
                TypedField<String> EXT12 = new TypedField<>(String.class, "settlementToSalesbills.ext12");
                TypedField<Long> ID = new TypedField<>(Long.class, "settlementToSalesbills.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "settlementToSalesbills.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "settlementToSalesbills.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "settlementToSalesbills.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "settlementToSalesbills.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "settlementToSalesbills.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "settlementToSalesbills.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "settlementToSalesbills.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "settlementToSalesbills.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "settlementToSalesbills.delete_flag");
                TypedField<String> EMAIL_RECORD = new TypedField<>(String.class, "settlementToSalesbills.email_record");
                TypedField<String> MESSAGE_RECORD = new TypedField<>(String.class, "settlementToSalesbills.message_record");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlementToSalesbills.settlement_no");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "settlementToSalesbills.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "settlementToSalesbills.tax_amount");
                TypedField<String> RELATE_ORDER_NO = new TypedField<>(String.class, "settlementToSalesbills.relate_order_no");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "settlementToSalesbills.purchaser_tax_no");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "settlementToSalesbills.purchaser_address");
                TypedField<String> PURCHASER_PHONE = new TypedField<>(String.class, "settlementToSalesbills.purchaser_phone");
                TypedField<String> PURCHASER_EMAIL = new TypedField<>(String.class, "settlementToSalesbills.purchaser_email");
                TypedField<String> PURCHASER_BANK = new TypedField<>(String.class, "settlementToSalesbills.purchaser_bank");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "settlementToSalesbills.purchaser_bank_account");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "settlementToSalesbills.seller_tax_no");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "settlementToSalesbills.seller_address");
                TypedField<String> SELLER_PHONE = new TypedField<>(String.class, "settlementToSalesbills.seller_phone");
                TypedField<String> SELLER_EMAIL = new TypedField<>(String.class, "settlementToSalesbills.seller_email");
                TypedField<String> SELLER_BANK = new TypedField<>(String.class, "settlementToSalesbills.seller_bank");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "settlementToSalesbills.seller_bank_account");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "settlementToSalesbills.upload_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "settlementToSalesbills.batch_no");
                TypedField<String> NO_COOP_SETTLEMENT_STATUS = new TypedField<>(String.class, "settlementToSalesbills.no_coop_settlement_status");
                TypedField<String> SETTLEMENT_FRONT = new TypedField<>(String.class, "settlementToSalesbills.settlement_front");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "settlementToSalesbills.invoice_type");
            }
        }
    }
    public interface MiroNoCoopSettlement {
        static Long id() {
            return 1554369358631190530L;
        }
        static String code() {
            return "miroNoCoopSettlement";
        }
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EMAIL_RECORD = new TypedField<>(String.class, "email_record");
        TypedField<String> MESSAGE_RECORD = new TypedField<>(String.class, "message_record");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> RELATE_ORDER_NO = new TypedField<>(String.class, "relate_order_no");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_PHONE = new TypedField<>(String.class, "purchaser_phone");
        TypedField<String> PURCHASER_EMAIL = new TypedField<>(String.class, "purchaser_email");
        TypedField<String> PURCHASER_BANK = new TypedField<>(String.class, "purchaser_bank");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_PHONE = new TypedField<>(String.class, "seller_phone");
        TypedField<String> SELLER_EMAIL = new TypedField<>(String.class, "seller_email");
        TypedField<String> SELLER_BANK = new TypedField<>(String.class, "seller_bank");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> NO_COOP_SETTLEMENT_STATUS = new TypedField<>(String.class, "no_coop_settlement_status");
        TypedField<String> SETTLEMENT_FRONT = new TypedField<>(String.class, "settlement_front");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface MiroNoCoopSettlementDetail {
        static Long id() {
            return 1554712687647133697L;
        }
        static String code() {
            return "miroNoCoopSettlementDetail";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<String> ORDER_ITEM = new TypedField<>(String.class, "order_item");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> LARGE_CATEGORY_NAME = new TypedField<>(String.class, "large_category_name");
        TypedField<String> SALESBILL_ITEM_NO = new TypedField<>(String.class, "salesbill_item_no");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT10_DETAIL = new TypedField<>(String.class, "ext10_detail");
        TypedField<String> MEDIAN_CATEGORY_NAME = new TypedField<>(String.class, "median_category_name");
        TypedField<String> SMALL_CATEGORY_NAME = new TypedField<>(String.class, "small_category_name");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT4_DETAIL = new TypedField<>(String.class, "ext4_detail");
        TypedField<String> ITEM_NO = new TypedField<>(String.class, "item_no");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "tax_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> UNIT_PRICE = new TypedField<>(String.class, "unit_price");
        TypedField<String> UNIT_PRICE_WITH_TAX = new TypedField<>(String.class, "unit_price_with_tax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        /**
         * 对一关联关系 关联对象 miroNoCoopSettlement
         */
        TypedField<Long> SETTLEMENT_TO_DETAILS_ID = new TypedField<>(Long.class, "settlementToDetails.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SETTLEMENT_TO_DETAILS {
                static String code () {
                    return "settlementToDetails" ;
                }
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementToDetails.amount_with_tax");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "settlementToDetails.seller_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "settlementToDetails.seller_name");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "settlementToDetails.purchaser_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "settlementToDetails.purchaser_name");
                TypedField<String> EXT12 = new TypedField<>(String.class, "settlementToDetails.ext12");
                TypedField<Long> ID = new TypedField<>(Long.class, "settlementToDetails.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "settlementToDetails.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "settlementToDetails.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "settlementToDetails.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "settlementToDetails.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "settlementToDetails.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "settlementToDetails.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "settlementToDetails.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "settlementToDetails.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "settlementToDetails.delete_flag");
                TypedField<String> EMAIL_RECORD = new TypedField<>(String.class, "settlementToDetails.email_record");
                TypedField<String> MESSAGE_RECORD = new TypedField<>(String.class, "settlementToDetails.message_record");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlementToDetails.settlement_no");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "settlementToDetails.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "settlementToDetails.tax_amount");
                TypedField<String> RELATE_ORDER_NO = new TypedField<>(String.class, "settlementToDetails.relate_order_no");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "settlementToDetails.purchaser_tax_no");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "settlementToDetails.purchaser_address");
                TypedField<String> PURCHASER_PHONE = new TypedField<>(String.class, "settlementToDetails.purchaser_phone");
                TypedField<String> PURCHASER_EMAIL = new TypedField<>(String.class, "settlementToDetails.purchaser_email");
                TypedField<String> PURCHASER_BANK = new TypedField<>(String.class, "settlementToDetails.purchaser_bank");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "settlementToDetails.purchaser_bank_account");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "settlementToDetails.seller_tax_no");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "settlementToDetails.seller_address");
                TypedField<String> SELLER_PHONE = new TypedField<>(String.class, "settlementToDetails.seller_phone");
                TypedField<String> SELLER_EMAIL = new TypedField<>(String.class, "settlementToDetails.seller_email");
                TypedField<String> SELLER_BANK = new TypedField<>(String.class, "settlementToDetails.seller_bank");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "settlementToDetails.seller_bank_account");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "settlementToDetails.upload_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "settlementToDetails.batch_no");
                TypedField<String> NO_COOP_SETTLEMENT_STATUS = new TypedField<>(String.class, "settlementToDetails.no_coop_settlement_status");
                TypedField<String> SETTLEMENT_FRONT = new TypedField<>(String.class, "settlementToDetails.settlement_front");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "settlementToDetails.invoice_type");
            }
        }
    }
}
