package com.xforceplus.ultraman.app.compass.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 扫描状态
 * </p>
 *
 * @author ultraman
 * @since 2022-05-20
 */
public enum ScanStatus {

    _0("0", "未扫描"),
    _1("1", "已扫描");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ScanStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ScanStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
