package com.xforceplus.ultraman.app.compass.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2022-05-20
*/
public class EntityMeta {
    public interface Bill {
        static Long id() {
            return 1423582025706938370L;
        }
        static String code() {
            return "bill";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<String> BILL_YY = new TypedField<>(String.class, "bill_yy");
        TypedField<String> BILL_YM = new TypedField<>(String.class, "bill_ym");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> PURCHASE_NAME = new TypedField<>(String.class, "purchase_name");
        TypedField<String> PURCHASE_TAX_NO = new TypedField<>(String.class, "purchase_tax_no");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<BigDecimal> REBATE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "rebate_without_tax");
        TypedField<BigDecimal> REBATE_WITH_TAX = new TypedField<>(BigDecimal.class, "rebate_with_tax");
        TypedField<BigDecimal> REBATE_AMOUNT = new TypedField<>(BigDecimal.class, "rebate_amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> PURCHASER_TENANT_ID = new TypedField<>(String.class, "purchaser_tenant_id");
        TypedField<String> SETTLEMENT_MODE = new TypedField<>(String.class, "settlement_mode");
        TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "settlement_status");
        TypedField<String> SELLER_TENANT_ID = new TypedField<>(String.class, "seller_tenant_id");
        TypedField<LocalDateTime> SETTLEMENT_CYCLE = new TypedField<>(LocalDateTime.class, "settlement_cycle");
        TypedField<String> SELLER_STATUS = new TypedField<>(String.class, "seller_status");
        TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "error_remark");
        TypedField<BigDecimal> GENERAL_WITH_TAX_REBATE = new TypedField<>(BigDecimal.class, "general_with_tax_rebate");
        TypedField<BigDecimal> SPECIAL_WITHOUT_TAX_REBATE = new TypedField<>(BigDecimal.class, "special_without_tax_rebate");
        TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "total_rebate");
    }
    public interface BillInvoice {
        static Long id() {
            return 1423584766047068162L;
        }
        static String code() {
            return "billInvoice";
        }
        TypedField<Long> BILL_ID = new TypedField<>(Long.class, "bill_id");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paper_drew_date");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> RED_FLAG = new TypedField<>(String.class, "red_flag");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> TOTAL_AMOUNT_TAX_NUM = new TypedField<>(BigDecimal.class, "total_amount_tax_num");
        TypedField<String> SETTLEMENT_MODE = new TypedField<>(String.class, "settlement_mode");
        TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "scan_status");
        TypedField<String> SCAN_TIME = new TypedField<>(String.class, "scan_time");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "auth_status");
        TypedField<String> AUTH_TIME = new TypedField<>(String.class, "auth_time");
        TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoice_color");
        TypedField<BigDecimal> REBATE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "rebate_without_tax");
        TypedField<BigDecimal> REBATE_WITH_TAX = new TypedField<>(BigDecimal.class, "rebate_with_tax");
        TypedField<BigDecimal> REBATE_AMOUNT = new TypedField<>(BigDecimal.class, "rebate_amount");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlement_cycle");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "red_notification_no");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<String> PROJECT_ADDR = new TypedField<>(String.class, "project_addr");
        TypedField<String> RED_TIME = new TypedField<>(String.class, "red_time");
        TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "total_rebate");
        TypedField<String> INVOICE = new TypedField<>(String.class, "invoice");
    }
    public interface BillDetails {
        static Long id() {
            return 1423587553002692609L;
        }
        static String code() {
            return "billDetails";
        }
        TypedField<Long> BILL_INVOICE_ID = new TypedField<>(Long.class, "bill_invoice_id");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "already_make_amount_without_tax");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "already_make_amount_with_tax");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT = new TypedField<>(BigDecimal.class, "already_make_amount");
        TypedField<BigDecimal> RATE = new TypedField<>(BigDecimal.class, "rate");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "sales_bill_no");
        TypedField<String> SALES_BILL_ITEM_NO = new TypedField<>(String.class, "sales_bill_item_no");
        TypedField<BigDecimal> REBATE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "rebate_without_tax");
        TypedField<BigDecimal> REBATE_WITH_TAX = new TypedField<>(BigDecimal.class, "rebate_with_tax");
        TypedField<BigDecimal> REBATE_AMOUNT = new TypedField<>(BigDecimal.class, "rebate_amount");
        TypedField<Long> REBATE_RATE = new TypedField<>(Long.class, "rebate_rate");
        TypedField<String> PROJECT_ADDR = new TypedField<>(String.class, "project_addr");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlement_cycle");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> ITEM_ID = new TypedField<>(Long.class, "item_id");
        TypedField<BigDecimal> REBATE_MONEY = new TypedField<>(BigDecimal.class, "rebate_money");
    }
    public interface YearBill {
        static Long id() {
            return 1499221813372588033L;
        }
        static String code() {
            return "yearBill";
        }
        TypedField<String> YEAR = new TypedField<>(String.class, "year");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_TENANT_ID = new TypedField<>(String.class, "seller_tenant_id");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_TENANT_ID = new TypedField<>(String.class, "purchaser_tenant_id");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "error_remark");
        TypedField<BigDecimal> GENERAL_WITH_TAX_REBATE = new TypedField<>(BigDecimal.class, "general_with_tax_rebate");
        TypedField<BigDecimal> SPECIAL_WITHOUT_TAX_REBATE = new TypedField<>(BigDecimal.class, "special_without_tax_rebate");
        TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "total_rebate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "year_bill_no");
        TypedField<String> CANCEL_REMARK = new TypedField<>(String.class, "cancel_remark");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface YearBillMain {
        static Long id() {
            return 1499244937229045761L;
        }
        static String code() {
            return "yearBillMain";
        }
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbill_no");
        TypedField<String> SALESBILL_TYPE = new TypedField<>(String.class, "salesbill_type");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> UPLOAD_MSG_ID = new TypedField<>(String.class, "upload_msg_id");
        TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "error_remark");
        TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "year_bill_no");
        /**
         * 对一关联关系 关联对象 yearBill
         */
        TypedField<Long> YEAR_BILL_ID = new TypedField<>(Long.class, "yearBill.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface YEAR_BILL {
                static String code () {
                    return "yearBill" ;
                }
                TypedField<String> YEAR = new TypedField<>(String.class, "yearBill.year");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "yearBill.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "yearBill.seller_tax_no");
                TypedField<String> SELLER_TENANT_ID = new TypedField<>(String.class, "yearBill.seller_tenant_id");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "yearBill.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "yearBill.purchaser_tax_no");
                TypedField<String> PURCHASER_TENANT_ID = new TypedField<>(String.class, "yearBill.purchaser_tenant_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "yearBill.status");
                TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "yearBill.error_remark");
                TypedField<BigDecimal> GENERAL_WITH_TAX_REBATE = new TypedField<>(BigDecimal.class, "yearBill.general_with_tax_rebate");
                TypedField<BigDecimal> SPECIAL_WITHOUT_TAX_REBATE = new TypedField<>(BigDecimal.class, "yearBill.special_without_tax_rebate");
                TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "yearBill.total_rebate");
                TypedField<Long> ID = new TypedField<>(Long.class, "yearBill.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "yearBill.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "yearBill.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "yearBill.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "yearBill.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "yearBill.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "yearBill.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "yearBill.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "yearBill.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "yearBill.delete_flag");
                TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "yearBill.year_bill_no");
                TypedField<String> CANCEL_REMARK = new TypedField<>(String.class, "yearBill.cancel_remark");
            }
        }
    }
    public interface YearBillDetail {
        static Long id() {
            return 1499248408695083010L;
        }
        static String code() {
            return "yearBillDetail";
        }
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbill_no");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> YEAR_BILL_ID = new TypedField<>(Long.class, "year_bill_id");
        TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "year_bill_no");
        /**
         * 对一关联关系 关联对象 yearBillMain
         */
        TypedField<Long> YEAR_BILL_MAIN_ID = new TypedField<>(Long.class, "yearBillMain.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface YEAR_BILL_MAIN {
                static String code () {
                    return "yearBillMain" ;
                }
                TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "yearBillMain.salesbill_no");
                TypedField<String> SALESBILL_TYPE = new TypedField<>(String.class, "yearBillMain.salesbill_type");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "yearBillMain.seller_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "yearBillMain.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "yearBillMain.seller_tax_no");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "yearBillMain.seller_tel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "yearBillMain.seller_address");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "yearBillMain.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "yearBillMain.seller_bank_account");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "yearBillMain.purchaser_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "yearBillMain.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "yearBillMain.purchaser_tax_no");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "yearBillMain.purchaser_tel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "yearBillMain.purchaser_address");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "yearBillMain.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "yearBillMain.purchaser_bank_account");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "yearBillMain.invoice_type");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "yearBillMain.price_method");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "yearBillMain.amount_with_tax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "yearBillMain.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "yearBillMain.tax_amount");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "yearBillMain.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "yearBillMain.origin_invoice_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "yearBillMain.upload_status");
                TypedField<Long> ID = new TypedField<>(Long.class, "yearBillMain.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "yearBillMain.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "yearBillMain.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "yearBillMain.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "yearBillMain.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "yearBillMain.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "yearBillMain.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "yearBillMain.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "yearBillMain.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "yearBillMain.delete_flag");
                TypedField<String> UPLOAD_MSG_ID = new TypedField<>(String.class, "yearBillMain.upload_msg_id");
                TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "yearBillMain.error_remark");
                TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "yearBillMain.year_bill_no");
            }
        }
    }
    public interface InvoiceDetail {
        static Long id() {
            return 1499741904803536898L;
        }
        static String code() {
            return "invoiceDetail";
        }
        TypedField<Long> BILL_ID = new TypedField<>(Long.class, "bill_id");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<Long> BILL_INVOICE_ID = new TypedField<>(Long.class, "bill_invoice_id");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<String> INVOICE_ITEM = new TypedField<>(String.class, "invoice_item");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargo_name");
        TypedField<String> QUANLITY_UNIT = new TypedField<>(String.class, "quanlity_unit");
    }
    public interface SalesbillUpload {
        static Long id() {
            return 1526052519228145666L;
        }
        static String code() {
            return "salesbillUpload";
        }
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "uploadStatus");
        TypedField<String> BILLING_SET_PERIOD = new TypedField<>(String.class, "billingSetPeriod");
        TypedField<LocalDateTime> UPLOAD_DATE = new TypedField<>(LocalDateTime.class, "uploadDate");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> RECEIPT_NO = new TypedField<>(String.class, "receiptNo");
    }
}
