package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum BizOrderType {

    GR("GR", "收货业务单"),
    RB("RB", "返利业务单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BizOrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderType fromCode(String code) {
        return Stream.of(BizOrderType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
