package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum InvoiceType {

    C("c", "增值税普通发票"),
    S("s", "增值税专用发票"),
    CE("ce", "增值税电子普通发票"),
    SE("se", "增值税电子专用发票"),
    V("v", "机动车销售发票"),
    T("t", "通用机打发票"),
    Y("y", "运输业增值税专用发票"),
    JU("ju", "增值税普通发票（卷票）"),
    VS("vs", "二手车发票"),
    CP("cp", "进口增值税缴款书发票"),
    CZ("cz", "全电增值税纸质普通发票"),
    QC("qc", "全电增值税电子普通发票"),
    SZ("sz", "全电增值税纸质专用发票"),
    QS("qs", "全电增值税电子专用发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code) {
        return Stream.of(InvoiceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
