package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_coop
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum IsCoop {

    _0("0", "非协同"),
    _1("1", "协同");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsCoop(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsCoop fromCode(String code) {
        return Stream.of(IsCoop.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
