package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * miro_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum MiroStatus {

    _0("0", "待扫描"),
    _1("1", "待发送"),
    _2("2", "发送成功"),
    _3("3", "发送失败"),
    _4("4", "校验/处理失败"),
    _5("5", "发送中"),
    _6("6", "扫描中");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MiroStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MiroStatus fromCode(String code) {
        return Stream.of(MiroStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
