package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * no_coop_settle_period
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum NoCoopSettlePeriod {

    _0("0", "月"),
    _1("1", "季"),
    _2("2", "半年"),
    _3("3", "年"),
    _4("4", "日");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoCoopSettlePeriod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoCoopSettlePeriod fromCode(String code) {
        return Stream.of(NoCoopSettlePeriod.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
