package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * no_coop_settlement_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum NoCoopSettlementStatus {

    _0("0", "未记账"),
    _1("1", "已记账"),
    _2("2", "作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoCoopSettlementStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoCoopSettlementStatus fromCode(String code) {
        return Stream.of(NoCoopSettlementStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
