package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * seller_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum SellerStatus {

    _2("2", "待确认"),
    _6("6", "已确认"),
    _7("7", "异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SellerStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerStatus fromCode(String code) {
        return Stream.of(SellerStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
