package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * verify_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum VerifyStatus {

    _0("0", "未查验"),
    _1("1", "待查验"),
    _2("2", "查验中"),
    _3("3", "查验成功"),
    _4("4", "查验失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VerifyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VerifyStatus fromCode(String code) {
        return Stream.of(VerifyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
