package com.xforceplus.ultraman.app.compass.metadata.validator;

import com.xforceplus.ultraman.app.compass.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.compass.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementMode.class)) {
            isValid = null != SettlementMode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SettlementMode.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementStatus.class)) {
            isValid = null != SettlementStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SettlementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IdentifyStatus.class)) {
            isValid = null != IdentifyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IdentifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedFlag.class)) {
            isValid = null != RedFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ScanStatus.class)) {
            isValid = null != ScanStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ScanStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = null != InvoiceColor.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerStatus.class)) {
            isValid = null != SellerStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SellerStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(YearBillStatus.class)) {
            isValid = null != YearBillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YearBillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadStatus.class)) {
            isValid = null != UploadStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UploadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = null != TaxPre.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = null != ZeroTax.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(IsImage.class)) {
            isValid = null != IsImage.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsImage.class.getSimpleName());
            }
        }
        if(clazz.equals(IsSend.class)) {
            isValid = null != IsSend.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsSend.class.getSimpleName());
            }
        }
        if(clazz.equals(MiroStatus.class)) {
            isValid = null != MiroStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MiroStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CommonIsOrNot.class)) {
            isValid = null != CommonIsOrNot.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CommonIsOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatus.class)) {
            isValid = null != VerifyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PlatInvoiceStatus.class)) {
            isValid = null != PlatInvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PlatInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCoop.class)) {
            isValid = null != IsCoop.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsCoop.class.getSimpleName());
            }
        }
        if(clazz.equals(NoCoopSalesbillStatus.class)) {
            isValid = null != NoCoopSalesbillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoCoopSalesbillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoCoopSettlementStatus.class)) {
            isValid = null != NoCoopSettlementStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoCoopSettlementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoCoopSettlePeriod.class)) {
            isValid = null != NoCoopSettlePeriod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoCoopSettlePeriod.class.getSimpleName());
            }
        }
        if(clazz.equals(IsRebate.class)) {
            isValid = null != IsRebate.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsRebate.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceMethod.class)) {
            isValid = null != PriceMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PriceMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderStatus.class)) {
            isValid = null != BizOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderType.class)) {
            isValid = null != BizOrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizOrderType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
