package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum BizOrderStatus {

    _0("0", "待处理"),
    _1("1", "成功"),
    _2("2", "失败"),
    _3("3", "故障");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BizOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderStatus fromCode(String code) {
        return Stream.of(BizOrderStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
