package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * identify_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum IdentifyStatus {

    _0("0", "默认"),
    _1("1", "不可认证"),
    _2("2", "未认证"),
    _3("3", "认证中"),
    _4("4", "已勾选"),
    _5("5", "认证失败"),
    _6("6", "认证异常"),
    _7("7", "已转出"),
    _8("8", "已认证");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IdentifyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IdentifyStatus fromCode(String code) {
        return Stream.of(IdentifyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
