package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_rebate
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum IsRebate {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsRebate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsRebate fromCode(String code) {
        return Stream.of(IsRebate.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
