package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * plat_invoice_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum PlatInvoiceStatus {

    _0("0", "0-默认    "),
    _1("1", "1-正常"),
    _2("2", "2-作废"),
    _3("3", "3-被红冲"),
    _4("4", "4-部分红冲"),
    _7("7", "7-异常"),
    _8("8", "8-失控 "),
    _9("9", "9-删除 ");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PlatInvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PlatInvoiceStatus fromCode(String code) {
        return Stream.of(PlatInvoiceStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
