package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * red_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum RedFlag {

    _0("0", "正常"),
    _1("1", "待红冲"),
    _2("2", "待部分红冲"),
    _3("3", "红冲"),
    _4("4", "部分红冲"),
    _5("5", "红冲票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RedFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedFlag fromCode(String code) {
        return Stream.of(RedFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
