package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * settlement_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum SettlementStatus {

    _0("0", "未生成"),
    _1("1", "已生成");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SettlementStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SettlementStatus fromCode(String code) {
        return Stream.of(SettlementStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
