package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * upload_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum UploadStatus {

    _0("0", "上传中"),
    _1("1", "已上传"),
    _2("2", "上传成功"),
    _3("3", "上传失败"),
    _4("4", "异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    UploadStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UploadStatus fromCode(String code) {
        return Stream.of(UploadStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
