package com.xforceplus.ultraman.app.compass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * year_bill_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum YearBillStatus {

    _0("0", "初始化"),
    _1("1", "计算中"),
    _2("2", "已发布"),
    _5("5", "已取消"),
    _6("6", "已确认"),
    _7("7", "异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    YearBillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YearBillStatus fromCode(String code) {
        return Stream.of(YearBillStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
