package com.xforceplus.ultraman.app.compass.metadata.validator;

import com.xforceplus.ultraman.app.compass.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.compass.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(Status.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementMode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SettlementMode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SettlementMode.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SettlementStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SettlementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IdentifyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IdentifyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IdentifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ScanStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ScanStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ScanStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceColor.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SellerStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SellerStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(YearBillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YearBillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YearBillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UploadStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UploadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxPre.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ZeroTax.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(IsImage.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsImage.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsImage.class.getSimpleName());
            }
        }
        if(clazz.equals(IsSend.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsSend.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsSend.class.getSimpleName());
            }
        }
        if(clazz.equals(MiroStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MiroStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MiroStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CommonIsOrNot.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CommonIsOrNot.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CommonIsOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VerifyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VerifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PlatInvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PlatInvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PlatInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCoop.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsCoop.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsCoop.class.getSimpleName());
            }
        }
        if(clazz.equals(NoCoopSalesbillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoCoopSalesbillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoCoopSalesbillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoCoopSettlementStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoCoopSettlementStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoCoopSettlementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoCoopSettlePeriod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoCoopSettlePeriod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoCoopSettlePeriod.class.getSimpleName());
            }
        }
        if(clazz.equals(IsRebate.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsRebate.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsRebate.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PriceMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PriceMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BizOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BizOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BizOrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BizOrderType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
