package com.xforceplus.ultraman.app.compass.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * year_bill
 * </p>
 *
 * @author ultraman
 * @since 2022-05-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class YearBill implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 年(yyyy)
   */
  private String year;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 销方租户ID
   */
  private String sellerTenantId;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 购方租户ID
   */
  private String purchaserTenantId;
  /**
   * 状态
   */
  private String status;
  /**
   * 异常原因
   */
  private String errorRemark;
  /**
   * 普票返利金额(含税)
   */
  private BigDecimal generalWithTaxRebate;
  /**
   * 专票返利金额(不含税)
   */
  private BigDecimal specialWithoutTaxRebate;
  /**
   * 合计返利金额
   */
  private BigDecimal totalRebate;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 年度账单编号
   */
  private String yearBillNo;
  /**
   * 取消原因
   */
  private String cancelRemark;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("year", year);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("seller_tenant_id", sellerTenantId);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_tenant_id", purchaserTenantId);
      map.put("status", status);
      map.put("error_remark", errorRemark);
      map.put("general_with_tax_rebate", generalWithTaxRebate);
      map.put("special_without_tax_rebate", specialWithoutTaxRebate);
      map.put("total_rebate", totalRebate);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("year_bill_no", yearBillNo);
      map.put("cancel_remark", cancelRemark);

      return map;
  }

  public static YearBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    YearBill entity = new YearBill();

    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String){
          entity.setYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tenant_id")) {
      Object obj = map.get("purchaser_tenant_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_remark")) {
      Object obj = map.get("error_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setErrorRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("general_with_tax_rebate")) {
      Object obj = map.get("general_with_tax_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGeneralWithTaxRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGeneralWithTaxRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGeneralWithTaxRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setGeneralWithTaxRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGeneralWithTaxRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("special_without_tax_rebate")) {
      Object obj = map.get("special_without_tax_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSpecialWithoutTaxRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSpecialWithoutTaxRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSpecialWithoutTaxRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSpecialWithoutTaxRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSpecialWithoutTaxRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_rebate")) {
      Object obj = map.get("total_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("year_bill_no")) {
      Object obj = map.get("year_bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setYearBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancel_remark")) {
      Object obj = map.get("cancel_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCancelRemark((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String){
            this.setYear((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTenantId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_tenant_id")) {
      Object obj = map.get("purchaser_tenant_id");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserTenantId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
            this.setStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("error_remark")) {
      Object obj = map.get("error_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setErrorRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("general_with_tax_rebate")) {
      Object obj = map.get("general_with_tax_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setGeneralWithTaxRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setGeneralWithTaxRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setGeneralWithTaxRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setGeneralWithTaxRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setGeneralWithTaxRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("special_without_tax_rebate")) {
      Object obj = map.get("special_without_tax_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSpecialWithoutTaxRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSpecialWithoutTaxRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSpecialWithoutTaxRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setSpecialWithoutTaxRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSpecialWithoutTaxRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("total_rebate")) {
      Object obj = map.get("total_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTotalRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("year_bill_no")) {
      Object obj = map.get("year_bill_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setYearBillNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cancel_remark")) {
      Object obj = map.get("cancel_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setCancelRemark((String)obj);
        }
      } else{
      }
   }

  }

}
