package com.xforceplus.ultraman.app.compass.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * MIRO状态
 * </p>
 *
 * @author ultraman
 * @since 2022-06-06
 */
public enum MiroStatus {

    _0("0", "待扫描"),
    _1("1", "待发送"),
    _2("2", "发送成功"),
    _3("3", "发送失败"),
    _4("4", "校验/处理失败"),
    _5("5", "已发送");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MiroStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MiroStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
