package com.xforceplus.ultraman.app.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.BillDetails;
import com.xforceplus.ultraman.app.compass.service.IBillDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 账单发票明细表前端控制器
 *
 * @author ultraman
 * @date 2022-03-03
 */
@RestController
public class BillDetailsController {

  @Autowired
  private IBillDetailsService billDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billDetails 账单发票明细表
   * @return
   */
  @GetMapping("/billdetailss" )
  public XfR getBillDetailss(XfPage page, BillDetails billDetails) {
    return XfR.ok(billDetailsServiceImpl.page(page, Wrappers.query(billDetails)));
  }

  /**
   * 通过id查询账单发票明细表
   * @param  id
   * @return XfR
   */
  @GetMapping("/billdetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billDetailsServiceImpl.getById(id));
  }

  /**
   * 新增账单发票明细表
   * @param billDetails 账单发票明细表
   * @return XfR
   */
  @PostMapping("/billdetailss")
  public XfR save(@RequestBody BillDetails billDetails) {
     return XfR.ok(billDetailsServiceImpl.save(billDetails));
  }

  /**
   * 修改-传入修改后的全部数据账单发票明细表
   * @param billDetails 账单发票明细表
   * @return XfR
   */
  @PutMapping("/billdetailss/{id}")
  public XfR putUpdate(@RequestBody BillDetails billDetails,@PathVariable Long id) {
      billDetails.setId(id);
      return XfR.ok(billDetailsServiceImpl.updateById(billDetails));
  }

  /**
   * 修改-传入修改的数据账单发票明细表
   * @param billDetails 账单发票明细表
   * @return XfR
   */
  @PatchMapping("/billdetailss/{id}")
  public XfR patchUpdate(@RequestBody BillDetails billDetails,@PathVariable Long id) {
      BillDetails upbillDetails = billDetailsServiceImpl.getById(id);
      if(upbillDetails != null){
        upbillDetails = ObjectCopyUtils.copyProperties(billDetails,upbillDetails,true);
      }
      return XfR.ok(billDetailsServiceImpl.updateById(upbillDetails));
  }

  /**
   * 通过id删除账单发票明细表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billdetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/billdetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_details");
     params.put("request", condition);

     return XfR.ok(billDetailsServiceImpl.querys(params));
  }

}
