package com.xforceplus.ultraman.app.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.MiroBillDetails;
import com.xforceplus.ultraman.app.compass.service.IMiroBillDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-16
 */
@RestController
public class MiroBillDetailsController {

  @Autowired
  private IMiroBillDetailsService miroBillDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param miroBillDetails ${table.comment}
   * @return
   */
  @GetMapping("/mirobilldetailss" )
  public XfR getMiroBillDetailss(XfPage page, MiroBillDetails miroBillDetails) {
    return XfR.ok(miroBillDetailsServiceImpl.page(page, Wrappers.query(miroBillDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/mirobilldetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(miroBillDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param miroBillDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/mirobilldetailss")
  public XfR save(@RequestBody MiroBillDetails miroBillDetails) {
     return XfR.ok(miroBillDetailsServiceImpl.save(miroBillDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param miroBillDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/mirobilldetailss/{id}")
  public XfR putUpdate(@RequestBody MiroBillDetails miroBillDetails,@PathVariable Long id) {
      miroBillDetails.setId(id);
      return XfR.ok(miroBillDetailsServiceImpl.updateById(miroBillDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param miroBillDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/mirobilldetailss/{id}")
  public XfR patchUpdate(@RequestBody MiroBillDetails miroBillDetails,@PathVariable Long id) {
      MiroBillDetails upmiroBillDetails = miroBillDetailsServiceImpl.getById(id);
      if(upmiroBillDetails != null){
        upmiroBillDetails = ObjectCopyUtils.copyProperties(miroBillDetails,upmiroBillDetails,true);
      }
      return XfR.ok(miroBillDetailsServiceImpl.updateById(upmiroBillDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mirobilldetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(miroBillDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/mirobilldetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "miro_bill_details");
     params.put("request", condition);

     return XfR.ok(miroBillDetailsServiceImpl.querys(params));
  }

}
