package com.xforceplus.ultraman.app.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.MiroNoCoopSalesbill;
import com.xforceplus.ultraman.app.compass.service.IMiroNoCoopSalesbillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-22
 */
@RestController
public class MiroNoCoopSalesbillController {

  @Autowired
  private IMiroNoCoopSalesbillService miroNoCoopSalesbillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param miroNoCoopSalesbill ${table.comment}
   * @return
   */
  @GetMapping("/mironocoopsalesbills" )
  public XfR getMiroNoCoopSalesbills(XfPage page, MiroNoCoopSalesbill miroNoCoopSalesbill) {
    return XfR.ok(miroNoCoopSalesbillServiceImpl.page(page, Wrappers.query(miroNoCoopSalesbill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/mironocoopsalesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(miroNoCoopSalesbillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param miroNoCoopSalesbill ${table.comment}
   * @return XfR
   */
  @PostMapping("/mironocoopsalesbills")
  public XfR save(@RequestBody MiroNoCoopSalesbill miroNoCoopSalesbill) {
     return XfR.ok(miroNoCoopSalesbillServiceImpl.save(miroNoCoopSalesbill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param miroNoCoopSalesbill ${table.comment}
   * @return XfR
   */
  @PutMapping("/mironocoopsalesbills/{id}")
  public XfR putUpdate(@RequestBody MiroNoCoopSalesbill miroNoCoopSalesbill,@PathVariable Long id) {
      miroNoCoopSalesbill.setId(id);
      return XfR.ok(miroNoCoopSalesbillServiceImpl.updateById(miroNoCoopSalesbill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param miroNoCoopSalesbill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/mironocoopsalesbills/{id}")
  public XfR patchUpdate(@RequestBody MiroNoCoopSalesbill miroNoCoopSalesbill,@PathVariable Long id) {
      MiroNoCoopSalesbill upmiroNoCoopSalesbill = miroNoCoopSalesbillServiceImpl.getById(id);
      if(upmiroNoCoopSalesbill != null){
        upmiroNoCoopSalesbill = ObjectCopyUtils.copyProperties(miroNoCoopSalesbill,upmiroNoCoopSalesbill,true);
      }
      return XfR.ok(miroNoCoopSalesbillServiceImpl.updateById(upmiroNoCoopSalesbill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mironocoopsalesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(miroNoCoopSalesbillServiceImpl.removeById(id));
  }

  @PostMapping("/mironocoopsalesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "miro_no_coop_salesbill");
     params.put("request", condition);

     return XfR.ok(miroNoCoopSalesbillServiceImpl.querys(params));
  }

}
