package com.xforceplus.ultraman.app.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.MiroOrderDetail;
import com.xforceplus.ultraman.app.compass.service.IMiroOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-22
 */
@RestController
public class MiroOrderDetailController {

  @Autowired
  private IMiroOrderDetailService miroOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param miroOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/miroorderdetails" )
  public XfR getMiroOrderDetails(XfPage page, MiroOrderDetail miroOrderDetail) {
    return XfR.ok(miroOrderDetailServiceImpl.page(page, Wrappers.query(miroOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/miroorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(miroOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param miroOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/miroorderdetails")
  public XfR save(@RequestBody MiroOrderDetail miroOrderDetail) {
     return XfR.ok(miroOrderDetailServiceImpl.save(miroOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param miroOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/miroorderdetails/{id}")
  public XfR putUpdate(@RequestBody MiroOrderDetail miroOrderDetail,@PathVariable Long id) {
      miroOrderDetail.setId(id);
      return XfR.ok(miroOrderDetailServiceImpl.updateById(miroOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param miroOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/miroorderdetails/{id}")
  public XfR patchUpdate(@RequestBody MiroOrderDetail miroOrderDetail,@PathVariable Long id) {
      MiroOrderDetail upmiroOrderDetail = miroOrderDetailServiceImpl.getById(id);
      if(upmiroOrderDetail != null){
        upmiroOrderDetail = ObjectCopyUtils.copyProperties(miroOrderDetail,upmiroOrderDetail,true);
      }
      return XfR.ok(miroOrderDetailServiceImpl.updateById(upmiroOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/miroorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(miroOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/miroorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "miro_order_detail");
     params.put("request", condition);

     return XfR.ok(miroOrderDetailServiceImpl.querys(params));
  }

}
