package com.xforceplus.ultraman.app.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.ItemMappingConfig;
import com.xforceplus.ultraman.app.compass.service.IItemMappingConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-19
 */
@RestController
public class ItemMappingConfigController {

  @Autowired
  private IItemMappingConfigService itemMappingConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param itemMappingConfig ${table.comment}
   * @return
   */
  @GetMapping("/itemmappingconfigs" )
  public XfR getItemMappingConfigs(XfPage page, ItemMappingConfig itemMappingConfig) {
    return XfR.ok(itemMappingConfigServiceImpl.page(page, Wrappers.query(itemMappingConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/itemmappingconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(itemMappingConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param itemMappingConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/itemmappingconfigs")
  public XfR save(@RequestBody ItemMappingConfig itemMappingConfig) {
     return XfR.ok(itemMappingConfigServiceImpl.save(itemMappingConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param itemMappingConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/itemmappingconfigs/{id}")
  public XfR putUpdate(@RequestBody ItemMappingConfig itemMappingConfig,@PathVariable Long id) {
      itemMappingConfig.setId(id);
      return XfR.ok(itemMappingConfigServiceImpl.updateById(itemMappingConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param itemMappingConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/itemmappingconfigs/{id}")
  public XfR patchUpdate(@RequestBody ItemMappingConfig itemMappingConfig,@PathVariable Long id) {
      ItemMappingConfig upitemMappingConfig = itemMappingConfigServiceImpl.getById(id);
      if(upitemMappingConfig != null){
        upitemMappingConfig = ObjectCopyUtils.copyProperties(itemMappingConfig,upitemMappingConfig,true);
      }
      return XfR.ok(itemMappingConfigServiceImpl.updateById(upitemMappingConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/itemmappingconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(itemMappingConfigServiceImpl.removeById(id));
  }

  @PostMapping("/itemmappingconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "item_mapping_config");
     params.put("request", condition);

     return XfR.ok(itemMappingConfigServiceImpl.querys(params));
  }

}
