package com.xforceplus.ultraman.app.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.BizOrder;
import com.xforceplus.ultraman.app.compass.service.IBizOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 与索迪斯重新对接SAP的业务单前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class BizOrderController {

  @Autowired
  private IBizOrderService bizOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrder 与索迪斯重新对接SAP的业务单
   * @return
   */
  @GetMapping("/bizorders" )
  public XfR getBizOrders(XfPage page, BizOrder bizOrder) {
    return XfR.ok(bizOrderServiceImpl.page(page, Wrappers.query(bizOrder)));
  }

  /**
   * 通过id查询与索迪斯重新对接SAP的业务单
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderServiceImpl.getById(id));
  }

  /**
   * 新增与索迪斯重新对接SAP的业务单
   * @param bizOrder 与索迪斯重新对接SAP的业务单
   * @return XfR
   */
  @PostMapping("/bizorders")
  public XfR save(@RequestBody BizOrder bizOrder) {
     return XfR.ok(bizOrderServiceImpl.save(bizOrder));
  }

  /**
   * 修改-传入修改后的全部数据与索迪斯重新对接SAP的业务单
   * @param bizOrder 与索迪斯重新对接SAP的业务单
   * @return XfR
   */
  @PutMapping("/bizorders/{id}")
  public XfR putUpdate(@RequestBody BizOrder bizOrder,@PathVariable Long id) {
      bizOrder.setId(id);
      return XfR.ok(bizOrderServiceImpl.updateById(bizOrder));
  }

  /**
   * 修改-传入修改的数据与索迪斯重新对接SAP的业务单
   * @param bizOrder 与索迪斯重新对接SAP的业务单
   * @return XfR
   */
  @PatchMapping("/bizorders/{id}")
  public XfR patchUpdate(@RequestBody BizOrder bizOrder,@PathVariable Long id) {
      BizOrder upbizOrder = bizOrderServiceImpl.getById(id);
      if(upbizOrder != null){
        upbizOrder = ObjectCopyUtils.copyProperties(bizOrder,upbizOrder,true);
      }
      return XfR.ok(bizOrderServiceImpl.updateById(upbizOrder));
  }

  /**
   * 通过id删除与索迪斯重新对接SAP的业务单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderServiceImpl.removeById(id));
  }

  @PostMapping("/bizorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order");
     params.put("request", condition);

     return XfR.ok(bizOrderServiceImpl.querys(params));
  }

}
