package com.xforceplus.ultraman.app.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.DiscountSellerConfig;
import com.xforceplus.ultraman.app.compass.service.IDiscountSellerConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class DiscountSellerConfigController {

  @Autowired
  private IDiscountSellerConfigService discountSellerConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param discountSellerConfig ${table.comment}
   * @return
   */
  @GetMapping("/discountsellerconfigs" )
  public XfR getDiscountSellerConfigs(XfPage page, DiscountSellerConfig discountSellerConfig) {
    return XfR.ok(discountSellerConfigServiceImpl.page(page, Wrappers.query(discountSellerConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/discountsellerconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(discountSellerConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param discountSellerConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/discountsellerconfigs")
  public XfR save(@RequestBody DiscountSellerConfig discountSellerConfig) {
     return XfR.ok(discountSellerConfigServiceImpl.save(discountSellerConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param discountSellerConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/discountsellerconfigs/{id}")
  public XfR putUpdate(@RequestBody DiscountSellerConfig discountSellerConfig,@PathVariable Long id) {
      discountSellerConfig.setId(id);
      return XfR.ok(discountSellerConfigServiceImpl.updateById(discountSellerConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param discountSellerConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/discountsellerconfigs/{id}")
  public XfR patchUpdate(@RequestBody DiscountSellerConfig discountSellerConfig,@PathVariable Long id) {
      DiscountSellerConfig updiscountSellerConfig = discountSellerConfigServiceImpl.getById(id);
      if(updiscountSellerConfig != null){
        updiscountSellerConfig = ObjectCopyUtils.copyProperties(discountSellerConfig,updiscountSellerConfig,true);
      }
      return XfR.ok(discountSellerConfigServiceImpl.updateById(updiscountSellerConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/discountsellerconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(discountSellerConfigServiceImpl.removeById(id));
  }

  @PostMapping("/discountsellerconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "discount_seller_config");
     params.put("request", condition);

     return XfR.ok(discountSellerConfigServiceImpl.querys(params));
  }

}
