package com.xforceplus.ultraman.app.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.BillInvoice;
import com.xforceplus.ultraman.app.compass.service.IBillInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 账单发票表前端控制器
 *
 * @author ultraman
 * @date 2025-10-28
 */
@RestController
public class BillInvoiceController {

  @Autowired
  private IBillInvoiceService billInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billInvoice 账单发票表
   * @return
   */
  @GetMapping("/billinvoices" )
  public XfR getBillInvoices(XfPage page, BillInvoice billInvoice) {
    return XfR.ok(billInvoiceServiceImpl.page(page, Wrappers.query(billInvoice)));
  }

  /**
   * 通过id查询账单发票表
   * @param  id
   * @return XfR
   */
  @GetMapping("/billinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增账单发票表
   * @param billInvoice 账单发票表
   * @return XfR
   */
  @PostMapping("/billinvoices")
  public XfR save(@RequestBody BillInvoice billInvoice) {
     return XfR.ok(billInvoiceServiceImpl.save(billInvoice));
  }

  /**
   * 修改-传入修改后的全部数据账单发票表
   * @param billInvoice 账单发票表
   * @return XfR
   */
  @PutMapping("/billinvoices/{id}")
  public XfR putUpdate(@RequestBody BillInvoice billInvoice,@PathVariable Long id) {
      billInvoice.setId(id);
      return XfR.ok(billInvoiceServiceImpl.updateById(billInvoice));
  }

  /**
   * 修改-传入修改的数据账单发票表
   * @param billInvoice 账单发票表
   * @return XfR
   */
  @PatchMapping("/billinvoices/{id}")
  public XfR patchUpdate(@RequestBody BillInvoice billInvoice,@PathVariable Long id) {
      BillInvoice upbillInvoice = billInvoiceServiceImpl.getById(id);
      if(upbillInvoice != null){
        upbillInvoice = ObjectCopyUtils.copyProperties(billInvoice,upbillInvoice,true);
      }
      return XfR.ok(billInvoiceServiceImpl.updateById(upbillInvoice));
  }

  /**
   * 通过id删除账单发票表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/billinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_invoice");
     params.put("request", condition);

     return XfR.ok(billInvoiceServiceImpl.querys(params));
  }

}
