package com.xforceplus.ultraman.app.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.MiroNoCoopSettlementDetail;
import com.xforceplus.ultraman.app.compass.service.IMiroNoCoopSettlementDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-28
 */
@RestController
public class MiroNoCoopSettlementDetailController {

  @Autowired
  private IMiroNoCoopSettlementDetailService miroNoCoopSettlementDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param miroNoCoopSettlementDetail ${table.comment}
   * @return
   */
  @GetMapping("/mironocoopsettlementdetails" )
  public XfR getMiroNoCoopSettlementDetails(XfPage page, MiroNoCoopSettlementDetail miroNoCoopSettlementDetail) {
    return XfR.ok(miroNoCoopSettlementDetailServiceImpl.page(page, Wrappers.query(miroNoCoopSettlementDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/mironocoopsettlementdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(miroNoCoopSettlementDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param miroNoCoopSettlementDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/mironocoopsettlementdetails")
  public XfR save(@RequestBody MiroNoCoopSettlementDetail miroNoCoopSettlementDetail) {
     return XfR.ok(miroNoCoopSettlementDetailServiceImpl.save(miroNoCoopSettlementDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param miroNoCoopSettlementDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/mironocoopsettlementdetails/{id}")
  public XfR putUpdate(@RequestBody MiroNoCoopSettlementDetail miroNoCoopSettlementDetail,@PathVariable Long id) {
      miroNoCoopSettlementDetail.setId(id);
      return XfR.ok(miroNoCoopSettlementDetailServiceImpl.updateById(miroNoCoopSettlementDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param miroNoCoopSettlementDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/mironocoopsettlementdetails/{id}")
  public XfR patchUpdate(@RequestBody MiroNoCoopSettlementDetail miroNoCoopSettlementDetail,@PathVariable Long id) {
      MiroNoCoopSettlementDetail upmiroNoCoopSettlementDetail = miroNoCoopSettlementDetailServiceImpl.getById(id);
      if(upmiroNoCoopSettlementDetail != null){
        upmiroNoCoopSettlementDetail = ObjectCopyUtils.copyProperties(miroNoCoopSettlementDetail,upmiroNoCoopSettlementDetail,true);
      }
      return XfR.ok(miroNoCoopSettlementDetailServiceImpl.updateById(upmiroNoCoopSettlementDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mironocoopsettlementdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(miroNoCoopSettlementDetailServiceImpl.removeById(id));
  }

  @PostMapping("/mironocoopsettlementdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "miro_no_coop_settlement_detail");
     params.put("request", condition);

     return XfR.ok(miroNoCoopSettlementDetailServiceImpl.querys(params));
  }

}
