package com.xforceplus.ultraman.app.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.compass.entity.SalesbillUpload;
import com.xforceplus.ultraman.app.compass.service.ISalesbillUploadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-28
 */
@RestController
public class SalesbillUploadController {

  @Autowired
  private ISalesbillUploadService salesbillUploadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesbillUpload ${table.comment}
   * @return
   */
  @GetMapping("/salesbilluploads" )
  public XfR getSalesbillUploads(XfPage page, SalesbillUpload salesbillUpload) {
    return XfR.ok(salesbillUploadServiceImpl.page(page, Wrappers.query(salesbillUpload)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbilluploads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesbillUploadServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesbillUpload ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesbilluploads")
  public XfR save(@RequestBody SalesbillUpload salesbillUpload) {
     return XfR.ok(salesbillUploadServiceImpl.save(salesbillUpload));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesbillUpload ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesbilluploads/{id}")
  public XfR putUpdate(@RequestBody SalesbillUpload salesbillUpload,@PathVariable Long id) {
      salesbillUpload.setId(id);
      return XfR.ok(salesbillUploadServiceImpl.updateById(salesbillUpload));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesbillUpload ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesbilluploads/{id}")
  public XfR patchUpdate(@RequestBody SalesbillUpload salesbillUpload,@PathVariable Long id) {
      SalesbillUpload upsalesbillUpload = salesbillUploadServiceImpl.getById(id);
      if(upsalesbillUpload != null){
        upsalesbillUpload = ObjectCopyUtils.copyProperties(salesbillUpload,upsalesbillUpload,true);
      }
      return XfR.ok(salesbillUploadServiceImpl.updateById(upsalesbillUpload));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbilluploads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesbillUploadServiceImpl.removeById(id));
  }

  @PostMapping("/salesbilluploads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "salesbill_upload");
     params.put("request", condition);

     return XfR.ok(salesbillUploadServiceImpl.querys(params));
  }

}
