package com.xforceplus.ultraman.app.difftest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.difftest.entity.Animal;
import com.xforceplus.ultraman.app.difftest.service.IAnimalService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-18
 */
@RestController
public class AnimalController {

  @Autowired
  private IAnimalService animalServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param animal ${table.comment}
   * @return
   */
  @GetMapping("/animals" )
  public XfR getAnimals(XfPage page, Animal animal) {
    return XfR.ok(animalServiceImpl.page(page, Wrappers.query(animal)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/animals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(animalServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param animal ${table.comment}
   * @return XfR
   */
  @PostMapping("/animals")
  public XfR save(@RequestBody Animal animal) {
     return XfR.ok(animalServiceImpl.save(animal));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param animal ${table.comment}
   * @return XfR
   */
  @PutMapping("/animals/{id}")
  public XfR putUpdate(@RequestBody Animal animal,@PathVariable Long id) {
      animal.setId(id);
      return XfR.ok(animalServiceImpl.updateById(animal));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param animal ${table.comment}
   * @return XfR
   */
  @PatchMapping("/animals/{id}")
  public XfR patchUpdate(@RequestBody Animal animal,@PathVariable Long id) {
      Animal upanimal = animalServiceImpl.getById(id);
      if(upanimal != null){
        upanimal = ObjectCopyUtils.copyProperties(animal,upanimal,true);
      }
      return XfR.ok(animalServiceImpl.updateById(upanimal));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/animals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(animalServiceImpl.removeById(id));
  }

  @PostMapping("/animals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "animal");
     params.put("request", condition);

     return XfR.ok(animalServiceImpl.querys(params));
  }

}
