package com.xforceplus.ultraman.app.difftest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.difftest.entity.Book;
import com.xforceplus.ultraman.app.difftest.service.IBookService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-18
 */
@RestController
public class BookController {

  @Autowired
  private IBookService bookServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param book ${table.comment}
   * @return
   */
  @GetMapping("/books" )
  public XfR getBooks(XfPage page, Book book) {
    return XfR.ok(bookServiceImpl.page(page, Wrappers.query(book)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/books/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bookServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param book ${table.comment}
   * @return XfR
   */
  @PostMapping("/books")
  public XfR save(@RequestBody Book book) {
     return XfR.ok(bookServiceImpl.save(book));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param book ${table.comment}
   * @return XfR
   */
  @PutMapping("/books/{id}")
  public XfR putUpdate(@RequestBody Book book,@PathVariable Long id) {
      book.setId(id);
      return XfR.ok(bookServiceImpl.updateById(book));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param book ${table.comment}
   * @return XfR
   */
  @PatchMapping("/books/{id}")
  public XfR patchUpdate(@RequestBody Book book,@PathVariable Long id) {
      Book upbook = bookServiceImpl.getById(id);
      if(upbook != null){
        upbook = ObjectCopyUtils.copyProperties(book,upbook,true);
      }
      return XfR.ok(bookServiceImpl.updateById(upbook));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/books/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bookServiceImpl.removeById(id));
  }

  @PostMapping("/books/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "book");
     params.put("request", condition);

     return XfR.ok(bookServiceImpl.querys(params));
  }

}
