package com.xforceplus.ultraman.app.difftest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.difftest.entity.Person;
import com.xforceplus.ultraman.app.difftest.service.IPersonService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-18
 */
@RestController
public class PersonController {

  @Autowired
  private IPersonService personServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param person ${table.comment}
   * @return
   */
  @GetMapping("/persons" )
  public XfR getPersons(XfPage page, Person person) {
    return XfR.ok(personServiceImpl.page(page, Wrappers.query(person)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/persons/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(personServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param person ${table.comment}
   * @return XfR
   */
  @PostMapping("/persons")
  public XfR save(@RequestBody Person person) {
     return XfR.ok(personServiceImpl.save(person));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param person ${table.comment}
   * @return XfR
   */
  @PutMapping("/persons/{id}")
  public XfR putUpdate(@RequestBody Person person,@PathVariable Long id) {
      person.setId(id);
      return XfR.ok(personServiceImpl.updateById(person));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param person ${table.comment}
   * @return XfR
   */
  @PatchMapping("/persons/{id}")
  public XfR patchUpdate(@RequestBody Person person,@PathVariable Long id) {
      Person upperson = personServiceImpl.getById(id);
      if(upperson != null){
        upperson = ObjectCopyUtils.copyProperties(person,upperson,true);
      }
      return XfR.ok(personServiceImpl.updateById(upperson));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/persons/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(personServiceImpl.removeById(id));
  }

  @PostMapping("/persons/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "person");
     params.put("request", condition);

     return XfR.ok(personServiceImpl.querys(params));
  }

}
