package com.xforceplus.ultraman.app.difftest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.difftest.entity.Testbo;
import com.xforceplus.ultraman.app.difftest.service.ITestboService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-18
 */
@RestController
public class TestboController {

  @Autowired
  private ITestboService testboServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testbo ${table.comment}
   * @return
   */
  @GetMapping("/testbos" )
  public XfR getTestbos(XfPage page, Testbo testbo) {
    return XfR.ok(testboServiceImpl.page(page, Wrappers.query(testbo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testbos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testboServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testbo ${table.comment}
   * @return XfR
   */
  @PostMapping("/testbos")
  public XfR save(@RequestBody Testbo testbo) {
     return XfR.ok(testboServiceImpl.save(testbo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testbo ${table.comment}
   * @return XfR
   */
  @PutMapping("/testbos/{id}")
  public XfR putUpdate(@RequestBody Testbo testbo,@PathVariable Long id) {
      testbo.setId(id);
      return XfR.ok(testboServiceImpl.updateById(testbo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testbo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testbos/{id}")
  public XfR patchUpdate(@RequestBody Testbo testbo,@PathVariable Long id) {
      Testbo uptestbo = testboServiceImpl.getById(id);
      if(uptestbo != null){
        uptestbo = ObjectCopyUtils.copyProperties(testbo,uptestbo,true);
      }
      return XfR.ok(testboServiceImpl.updateById(uptestbo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testbos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testboServiceImpl.removeById(id));
  }

  @PostMapping("/testbos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testbo");
     params.put("request", condition);

     return XfR.ok(testboServiceImpl.querys(params));
  }

}
